"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestsViewComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _adapters = require("../../../../common/adapters");
var _request_selector = require("./request_selector");
var _request_details = require("./request_details");
var _disambiguate_request_names = require("./disambiguate_request_names");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/requests_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getInitialRequest(requests, initialRequestId) {
  const initialRequest = initialRequestId ? requests.find(({
    id
  }) => id === initialRequestId) : undefined;
  if (initialRequest) {
    return initialRequest;
  }
  return requests.length ? requests[0] : null;
}
class RequestsViewComponent extends _react.Component {
  constructor(props) {
    var _this$props$options;
    super(props);
    (0, _defineProperty2.default)(this, "_onRequestsChange", () => {
      const requests = this.getRequests();
      const newState = {
        requests
      };
      if (!this.state.request || !requests.includes(this.state.request)) {
        newState.request = requests.length ? requests[0] : null;
      }
      this.setState(newState);
    });
    (0, _defineProperty2.default)(this, "selectRequest", request => {
      if (request !== this.state.request) {
        this.setState({
          request
        });
      }
    });
    props.adapters.requests.on('change', this._onRequestsChange);
    const _requests = this.getRequests();
    this.state = {
      requests: _requests,
      request: getInitialRequest(_requests, (_this$props$options = this.props.options) === null || _this$props$options === void 0 ? void 0 : _this$props$options.initialRequestId)
    };
  }
  getRequests() {
    return (0, _disambiguate_request_names.disambiguateRequestNames)(this.props.adapters.requests.getRequests());
  }
  componentWillUnmount() {
    this.props.adapters.requests.removeListener('change', this._onRequestsChange);
  }
  static renderEmptyRequests() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "inspectorNoRequestsMessage",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.noRequestsLoggedTitle",
        defaultMessage: "No requests logged",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.noRequestsLoggedDescription.elementHasNotLoggedAnyRequestsText",
        defaultMessage: "The element hasn't logged any requests (yet).",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.noRequestsLoggedDescription.whatDoesItUsuallyMeanText",
        defaultMessage: "This usually means that there was no need to fetch any data or that the element has not yet started fetching data.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 15
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    });
  }
  render() {
    var _this$props$options2;
    if (!this.state.requests || !this.state.requests.length) {
      return RequestsViewComponent.renderEmptyRequests();
    }
    const failedCount = this.state.requests.filter(req => req.status === _adapters.RequestStatus.ERROR).length;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      role: "status",
      "aria-live": "polite",
      "aria-atomic": "true",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.requests.requestWasMadeDescription",
      defaultMessage: "{requestsCount, plural, one {# request was} other {# requests were} } made{failedRequests}",
      values: {
        requestsCount: this.state.requests.length,
        failedRequests: failedCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "danger",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "inspector.requests.requestWasMadeDescription.requestHadFailureText",
          defaultMessage: ", {failedCount} had a failure",
          values: {
            failedCount
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 23
          }
        })) : ''
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }), this.state.request && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_request_selector.RequestSelector, {
      requests: this.state.requests,
      selectedRequest: this.state.request,
      onRequestChanged: this.selectRequest,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    })), this.state.request && this.state.request.description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    }, this.state.request.description)), this.state.request && this.state.request.searchSessionId && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": 'inspectorRequestSearchSessionId',
      "data-search-session-id": this.state.request.searchSessionId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.requests.searchSessionId",
      defaultMessage: "Background search id: {searchSessionId}",
      values: {
        searchSessionId: this.state.request.searchSessionId
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }), this.state.request && /*#__PURE__*/_react.default.createElement(_request_details.RequestDetails, {
      initialTabs: (_this$props$options2 = this.props.options) === null || _this$props$options2 === void 0 ? void 0 : _this$props$options2.initialTabs,
      request: this.state.request,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 11
      }
    }));
  }
}
exports.RequestsViewComponent = RequestsViewComponent;