"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParentCandidates = getParentCandidates;
var _editor_utils = require("../editor_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getParentCandidates(controlParamsList, controlId, lineageMap) {
  return controlParamsList.filter(controlParams => {
    // Ignore controls that do not have index pattern and field set
    if (!controlParams.indexPattern || !controlParams.fieldName) {
      return false;
    }
    // Ignore controls that would create a circular graph
    const lineage = lineageMap.get(controlParams.id);
    if (lineage !== null && lineage !== void 0 && lineage.includes(controlId)) {
      return false;
    }
    return true;
  }).map((controlParams, controlIndex) => {
    return {
      value: controlParams.id,
      text: (0, _editor_utils.getTitle)(controlParams, controlIndex)
    };
  });
}