"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoipList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
var _shared_imports = require("../../../shared_imports");
var _constants = require("./constants");
var _empty_list = require("./empty_list");
var _add_database_modal = require("./add_database_modal");
var _delete_database_modal = require("./delete_database_modal");
var _get_error_message = require("./get_error_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/manage_processors/geoip_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  table: (0, _react2.css)`
    height: 100%;
  `
};
const GeoipList = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const {
    data,
    isLoading,
    error,
    resendRequest
  } = services.api.useLoadDatabases();
  const [showModal, setShowModal] = (0, _react.useState)(null);
  const [databaseToDelete, setDatabaseToDelete] = (0, _react.useState)(null);
  const onDatabaseDelete = item => {
    setDatabaseToDelete(item);
    setShowModal('delete');
  };
  let content;
  const addDatabaseButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: () => {
      setShowModal('add');
    },
    "data-test-subj": "addGeoipDatabaseButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.addDatabaseButtonLabel",
    defaultMessage: "Add database",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
  const tableProps = {
    'data-test-subj': 'geoipDatabaseList',
    rowProps: () => ({
      'data-test-subj': 'geoipDatabaseListRow'
    }),
    columns: [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.nameColumnTitle', {
        defaultMessage: 'Database name'
      }),
      sortable: true,
      render: (name, row) => {
        if (row.type === 'ipinfo') {
          var _getDatabaseText;
          // Use the translated text for this database, if it exists
          return (_getDatabaseText = (0, _utils.getDatabaseText)(name, 'ipinfo')) !== null && _getDatabaseText !== void 0 ? _getDatabaseText : name;
        }
        return name;
      }
    }, {
      field: 'type',
      name: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.typeColumnTitle', {
        defaultMessage: 'Type'
      }),
      sortable: true,
      render: type => {
        return (0, _constants.getTypeLabel)(type);
      }
    }, {
      name: 'Actions',
      align: 'right',
      render: item => {
        // Local and web databases are read only and cannot be deleted through UI
        if (['web', 'local'].includes(item.type)) {
          return;
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          name: "Delete",
          "aria-label": _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.actionIconLabel', {
            defaultMessage: 'Delete this database'
          }),
          iconType: "trash",
          color: "danger",
          onClick: () => onDatabaseDelete(item),
          "data-test-subj": "deleteGeoipDatabaseButton",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 13
          }
        });
      }
    }],
    items: data !== null && data !== void 0 ? data : []
  };
  if (error) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        "data-test-subj": "geoipListLoadingError",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.manageProcessors.geoip.list.loadErrorTitle",
        defaultMessage: "Unable to load geoIP databases",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 15
        }
      }, (0, _get_error_message.getErrorMessage)(error)),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.manageProcessors.geoip.list.geoipListReloadButton",
        defaultMessage: "Try again",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    });
  } else if (isLoading && !data) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      "data-test-subj": "sectionLoading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.list.loadingMessage",
      defaultMessage: "Loading geoIP databases...",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    }));
  } else if (data && data.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_empty_list.EmptyList, {
      addDatabaseButton: addDatabaseButton,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 15
      }
    });
  } else {
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.tableTitle",
      defaultMessage: "IP Location",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }, addDatabaseButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({
      css: styles.table
    }, tableProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 9
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content, showModal === 'add' && /*#__PURE__*/_react.default.createElement(_add_database_modal.AddDatabaseModal, {
    closeModal: () => setShowModal(null),
    reloadDatabases: resendRequest,
    databases: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }), showModal === 'delete' && databaseToDelete && /*#__PURE__*/_react.default.createElement(_delete_database_modal.DeleteDatabaseModal, {
    database: databaseToDelete,
    reloadDatabases: resendRequest,
    closeModal: () => setShowModal(null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }));
};
exports.GeoipList = GeoipList;