"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Pipeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/pipeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.pipelineForm.pipelineNameFieldLabel', {
      defaultMessage: 'Pipeline name'
    }),
    deserializer: String,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.pipelineForm.pipelineNameFieldHelpText', {
      defaultMessage: 'Name of the ingest pipeline to run.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.pipelineForm.pipelineNameRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  },
  /* Optional field configs */
  ignore_missing_pipeline: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.pipelineForm.ignoreMissingPipelineFieldLabel', {
      defaultMessage: 'Ignore missing pipeline'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.pipelineForm.ignoreMissingPipelineFieldHelpText', {
      defaultMessage: 'Ignore missing pipelines instead of failing.'
    })
  }
};
const Pipeline = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "pipelineNameField",
    config: fieldsConfig.name,
    component: _shared_imports.Field,
    path: "fields.name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "ignoreMissingPipelineSwitch",
    config: fieldsConfig.ignore_missing_pipeline,
    component: _shared_imports.ToggleField,
    path: "fields.ignore_missing_pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
};
exports.Pipeline = Pipeline;