"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsTimeContext = exports.useMetricsTime = exports.replaceMetricTimeInQueryString = exports.MetricsTimeUrlStateRT = exports.MetricsTimeProvider = exports.MetricsTimeInputRT = exports.MetricsTimeContainer = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/pipeable");
var _Either = require("fp-ts/Either");
var _function = require("fp-ts/function");
var _public = require("@kbn/observability-shared-plugin/public");
var _url_state_storage_service = require("../../../../../common/url_state_storage_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseRange = range => {
  const parsedFrom = _datemath.default.parse(range.from.toString());
  const parsedTo = _datemath.default.parse(range.to.toString(), {
    roundUp: true
  });
  return {
    ...range,
    from: parsedFrom && parsedFrom.valueOf() || (0, _moment.default)().subtract(1, 'hour').valueOf(),
    to: parsedTo && parsedTo.valueOf() || (0, _moment.default)().valueOf()
  };
};
const DEFAULT_TIMERANGE = {
  from: 'now-1h',
  to: 'now',
  interval: '>=1m'
};
const DEFAULT_URL_STATE = {
  time: DEFAULT_TIMERANGE,
  autoReload: false,
  refreshInterval: 5000
};
const useMetricsTime = () => {
  const [urlState, setUrlState] = (0, _public.useUrlState)({
    defaultState: DEFAULT_URL_STATE,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: '_a'
  });
  const [isAutoReloading, setAutoReload] = (0, _react.useState)(urlState.autoReload || false);
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(urlState.refreshInterval || 5000);
  const [lastRefresh, setLastRefresh] = (0, _react.useState)((0, _moment.default)().valueOf());
  const [timeRange, setTimeRange] = (0, _react.useState)({
    ...DEFAULT_TIMERANGE,
    ...urlState.time
  });
  (0, _react.useEffect)(() => {
    const newState = {
      time: timeRange,
      autoReload: isAutoReloading,
      refreshInterval
    };
    return setUrlState(newState);
  }, [isAutoReloading, refreshInterval, setUrlState, timeRange]);
  const [parsedTimeRange, setParsedTimeRange] = (0, _react.useState)(parseRange(urlState.time || DEFAULT_TIMERANGE));
  const updateTimeRange = (0, _react.useCallback)((range, parseDate = true) => {
    setTimeRange(range);
    if (parseDate) {
      setParsedTimeRange(parseRange(range));
    }
  }, []);
  return {
    timeRange,
    setTimeRange: updateTimeRange,
    parsedTimeRange,
    refreshInterval,
    setRefreshInterval,
    isAutoReloading,
    setAutoReload,
    lastRefresh,
    triggerRefresh: (0, _react.useCallback)(() => {
      return setLastRefresh((0, _moment.default)().valueOf());
    }, [setLastRefresh])
  };
};
exports.useMetricsTime = useMetricsTime;
const MetricsTimeInputRT = exports.MetricsTimeInputRT = rt.type({
  from: rt.union([rt.string, rt.number]),
  to: rt.union([rt.string, rt.number]),
  interval: rt.string
});
const MetricsTimeUrlStateRT = exports.MetricsTimeUrlStateRT = rt.partial({
  time: MetricsTimeInputRT,
  autoReload: rt.boolean,
  refreshInterval: rt.number
});
const encodeUrlState = MetricsTimeUrlStateRT.encode;
const decodeUrlState = value => (0, _pipeable.pipe)(MetricsTimeUrlStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
const replaceMetricTimeInQueryString = (from, to) => Number.isNaN(from) || Number.isNaN(to) ? value => value : (0, _url_state_storage_service.replaceStateKeyInQueryString)('_a', {
  autoReload: false,
  time: {
    interval: '>=1m',
    from: (0, _moment.default)(from).toISOString(),
    to: (0, _moment.default)(to).toISOString()
  }
});
exports.replaceMetricTimeInQueryString = replaceMetricTimeInQueryString;
const MetricsTimeContainer = exports.MetricsTimeContainer = (0, _constate.default)(useMetricsTime);
const [MetricsTimeProvider, useMetricsTimeContext] = MetricsTimeContainer;
exports.useMetricsTimeContext = useMetricsTimeContext;
exports.MetricsTimeProvider = MetricsTimeProvider;