"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnalysisSetupState = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _log_analysis = require("../../../../common/log_analysis");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_tracked_promise = require("../../../hooks/use_tracked_promise");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fourWeeksInMs = 86400000 * 7 * 4;
const useAnalysisSetupState = ({
  cleanUpAndSetUpModule,
  moduleDescriptor: {
    validateSetupDatasets,
    validateSetupIndices
  },
  setUpModule,
  sourceConfiguration
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [startTime, setStartTime] = (0, _react.useState)(Date.now() - fourWeeksInMs);
  const [endTime, setEndTime] = (0, _react.useState)(undefined);
  const isTimeRangeValid = (0, _react.useMemo)(() => startTime != null && endTime != null ? startTime < endTime : true, [endTime, startTime]);
  const [validatedIndices, setValidatedIndices] = (0, _react.useState)(sourceConfiguration.indices.map(indexName => ({
    name: indexName,
    validity: 'unknown'
  })));
  const updateIndicesWithValidationErrors = (0, _react.useCallback)(validationErrors => setValidatedIndices(availableIndices => availableIndices.map(previousAvailableIndex => {
    const indexValiationErrors = validationErrors.filter(({
      index
    }) => index === previousAvailableIndex.name);
    if (indexValiationErrors.length > 0) {
      return {
        validity: 'invalid',
        name: previousAvailableIndex.name,
        errors: indexValiationErrors
      };
    } else if (previousAvailableIndex.validity === 'valid') {
      return {
        ...previousAvailableIndex,
        validity: 'valid',
        errors: []
      };
    } else {
      return {
        validity: 'valid',
        name: previousAvailableIndex.name,
        isSelected: !(0, _log_analysis.isExampleDataIndex)(previousAvailableIndex.name),
        availableDatasets: [],
        datasetFilter: {
          type: 'includeAll'
        }
      };
    }
  })), []);
  const updateIndicesWithAvailableDatasets = (0, _react.useCallback)(availableDatasets => setValidatedIndices(availableIndices => availableIndices.map(previousAvailableIndex => {
    if (previousAvailableIndex.validity !== 'valid') {
      return previousAvailableIndex;
    }
    const availableDatasetsForIndex = availableDatasets.filter(({
      indexName
    }) => indexName === previousAvailableIndex.name);
    const newAvailableDatasets = availableDatasetsForIndex.flatMap(({
      datasets
    }) => datasets);

    // filter out datasets that have disappeared if this index' datasets were updated
    const newDatasetFilter = availableDatasetsForIndex.length > 0 ? (0, _log_analysis.filterDatasetFilter)(previousAvailableIndex.datasetFilter, dataset => newAvailableDatasets.includes(dataset)) : previousAvailableIndex.datasetFilter;
    return {
      ...previousAvailableIndex,
      availableDatasets: newAvailableDatasets,
      datasetFilter: newDatasetFilter
    };
  })), []);
  const validIndexNames = (0, _react.useMemo)(() => validatedIndices.filter(index => index.validity === 'valid').map(index => index.name), [validatedIndices]);
  const selectedIndexNames = (0, _react.useMemo)(() => validatedIndices.filter(index => index.validity === 'valid' && index.isSelected).map(i => i.name), [validatedIndices]);
  const datasetFilter = (0, _react.useMemo)(() => validatedIndices.flatMap(validatedIndex => validatedIndex.validity === 'valid' ? validatedIndex.datasetFilter : {
    type: 'includeAll'
  }).reduce(_log_analysis.combineDatasetFilters, {
    type: 'includeAll'
  }), [validatedIndices]);
  const [validateIndicesRequest, validateIndices] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      return await validateSetupIndices(sourceConfiguration.indices, sourceConfiguration.timestampField, sourceConfiguration.runtimeMappings, services.http.fetch);
    },
    onResolve: ({
      data: {
        errors
      }
    }) => {
      updateIndicesWithValidationErrors(errors);
    },
    onReject: () => {
      setValidatedIndices([]);
    }
  }, [sourceConfiguration.indices, sourceConfiguration.timestampField]);
  const [validateDatasetsRequest, validateDatasets] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      if (validIndexNames.length === 0) {
        return {
          data: {
            datasets: []
          }
        };
      }
      return await validateSetupDatasets(validIndexNames, sourceConfiguration.timestampField, startTime !== null && startTime !== void 0 ? startTime : 0, endTime !== null && endTime !== void 0 ? endTime : Date.now(), sourceConfiguration.runtimeMappings, services.http.fetch);
    },
    onResolve: ({
      data: {
        datasets
      }
    }) => {
      updateIndicesWithAvailableDatasets(datasets);
    }
  }, [validIndexNames, sourceConfiguration.timestampField, startTime, endTime]);
  const setUp = (0, _react.useCallback)(() => {
    return setUpModule(selectedIndexNames, startTime, endTime, datasetFilter);
  }, [setUpModule, selectedIndexNames, startTime, endTime, datasetFilter]);
  const cleanUpAndSetUp = (0, _react.useCallback)(() => {
    return cleanUpAndSetUpModule(selectedIndexNames, startTime, endTime, datasetFilter);
  }, [cleanUpAndSetUpModule, selectedIndexNames, startTime, endTime, datasetFilter]);
  const isValidating = (0, _react.useMemo)(() => validateIndicesRequest.state === 'pending' || validateDatasetsRequest.state === 'pending', [validateDatasetsRequest.state, validateIndicesRequest.state]);
  const validationErrors = (0, _react.useMemo)(() => {
    if (isValidating) {
      return [];
    }
    return [
    // validate request status
    ...(validateIndicesRequest.state === 'rejected' || validateDatasetsRequest.state === 'rejected' ? [{
      error: 'NETWORK_ERROR'
    }] : []),
    // validation request results
    ...validatedIndices.reduce((errors, index) => {
      return index.validity === 'invalid' && selectedIndexNames.includes(index.name) ? [...errors, ...index.errors] : errors;
    }, []),
    // index count
    ...(selectedIndexNames.length === 0 ? [{
      error: 'TOO_FEW_SELECTED_INDICES'
    }] : []),
    // time range
    ...(!isTimeRangeValid ? [{
      error: 'INVALID_TIME_RANGE'
    }] : [])];
  }, [isValidating, validateIndicesRequest.state, validateDatasetsRequest.state, validatedIndices, selectedIndexNames, isTimeRangeValid]);
  const prevStartTime = (0, _usePrevious.default)(startTime);
  const prevEndTime = (0, _usePrevious.default)(endTime);
  const prevValidIndexNames = (0, _usePrevious.default)(validIndexNames);
  (0, _react.useEffect)(() => {
    if (!isTimeRangeValid) {
      return;
    }
    validateIndices();
  }, [isTimeRangeValid, validateIndices]);
  (0, _react.useEffect)(() => {
    if (!isTimeRangeValid) {
      return;
    }
    if (startTime !== prevStartTime || endTime !== prevEndTime || !(0, _lodash.isEqual)(validIndexNames, prevValidIndexNames)) {
      validateDatasets();
    }
  }, [endTime, isTimeRangeValid, prevEndTime, prevStartTime, prevValidIndexNames, startTime, validIndexNames, validateDatasets]);
  return {
    cleanUpAndSetUp,
    datasetFilter,
    endTime,
    isValidating,
    selectedIndexNames,
    setEndTime,
    setStartTime,
    setUp,
    startTime,
    validatedIndices,
    setValidatedIndices,
    validationErrors
  };
};
exports.useAnalysisSetupState = useAnalysisSetupState;