"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopProcessesTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _popover = require("../tabs/common/popover");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/components/top_processes_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DOCUMENTATION_LINK = 'https://www.elastic.co/guide/en/observability/current/view-infrastructure-metrics.html';
const SYSTEM_INTEGRATION_DOCS_LINK = 'https://ela.st/hosts-ui-systems-integration';
const SEMCONV_INTEGRATION_DOCS_LINK = 'https://ela.st/otel-process-hosts-ui';
const TopProcessesTooltip = exports.TopProcessesTooltip = /*#__PURE__*/_react.default.memo(() => {
  const {
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processesHeader.tooltipLabel', {
      defaultMessage: 'More info'
    }),
    iconSize: "m",
    icon: "info",
    "data-test-subj": "infraAssetDetailsProcessesPopoverButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      width: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.topProcesses",
    defaultMessage: "The processes listed are based on an aggregation of the top CPU and the top memory consuming processes. It does not show all processes.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  })), schema === 'ecs' ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.ecsLabel",
    defaultMessage: "You can configure the {systemIntegration} to emit process data for your hosts.",
    values: {
      systemIntegration: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipECSIntegrationDocumentationLink",
        href: SYSTEM_INTEGRATION_DOCS_LINK,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.processes.tooltip.ecsIntegrationDocumentationLink",
        defaultMessage: "System Integration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.semconvLabel",
    defaultMessage: "You can {configureOpenTelemetryCollector} to emit process data for your hosts.",
    values: {
      configureOpenTelemetryCollector: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipSemconvIntegrationDocumentationLink",
        href: SEMCONV_INTEGRATION_DOCS_LINK,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.processes.tooltip.semconvIntegrationDocumentationLink",
        defaultMessage: "configure your OpenTelemetry Collector",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.documentationLabel",
    defaultMessage: "Please see our {documentation} for more details on processes.",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipDocumentationLink",
        href: DOCUMENTATION_LINK,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.processes.tooltip.documentationLink",
        defaultMessage: "documentation",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }))));
});