"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _constants = require("../../../common/visualizations/constants");
var _build = require("../../../utils/filters/build");
var _lens = require("../../lens");
var _use_date_picker = require("../hooks/use_date_picker");
var _chart_utils = require("./chart_utils");
var _use_reload_request_time = require("../../../hooks/use_reload_request_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/charts/chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Chart = ({
  id,
  queryField,
  overrides,
  dateRange,
  entityId,
  lensAttributes,
  dataView
}) => {
  const {
    setDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    reloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const {
    value: filters = []
  } = (0, _useAsync.default)(async () => {
    if (!dataView) {
      return [];
    }
    return [(0, _build.buildCombinedAssetFilter)({
      field: queryField,
      values: [entityId],
      dataView
    })];
  }, [dataView, queryField, entityId]);
  const handleBrushEnd = (0, _react.useCallback)(({
    range,
    preventDefault
  }) => {
    setDateRange({
      from: new Date(range[0]).toISOString(),
      to: new Date(range[1]).toISOString()
    });
    preventDefault();
  }, [setDateRange]);
  const handleFilter = (0, _react.useCallback)(event => {
    const range = (0, _chart_utils.extractRangeFromChartFilterEvent)(event);
    if (range === null) {
      return;
    }
    setDateRange(range);
    event.preventDefault();
  }, [setDateRange]);
  return /*#__PURE__*/_react.default.createElement(_lens.LensChart, {
    id: `infraAssetDetailsMetricChart${id}`,
    borderRadius: "m",
    dateRange: dateRange,
    height: _constants.METRIC_CHART_HEIGHT,
    lastReloadRequestTime: reloadRequestTime,
    filters: filters,
    lensAttributes: lensAttributes,
    overrides: overrides,
    onBrushEnd: handleBrushEnd,
    onFilter: handleFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
};
exports.Chart = Chart;