"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBySelector = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/common/group_by_expression/selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupBySelector = ({
  onChange,
  fields,
  selectedGroups = [],
  label,
  placeholder
}) => {
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const groupBy = selectedOptions.map(option => option.label);
    onChange(groupBy);
  }, [onChange]);
  const formattedSelectedGroups = (0, _react.useMemo)(() => {
    return selectedGroups.map(group => ({
      label: group
    }));
  }, [selectedGroups]);
  const options = (0, _react.useMemo)(() => {
    return fields.filter(field => field.aggregatable).map(field => ({
      label: field.name
    }));
  }, [fields]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: '300px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: placeholder,
    "aria-label": label,
    fullWidth: true,
    singleSelection: false,
    selectedOptions: formattedSelectedGroups,
    options: options,
    onChange: handleChange,
    isClearable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.GroupBySelector = GroupBySelector;