"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateEsqlTask = generateEsqlTask;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _common = require("../../../../common");
var _constants = require("../../../../common/tasks/nl_to_esql/constants");
var _shared = require("./shared");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_CALLS = 8;
function generateEsqlTask({
  chatCompleteApi,
  connectorId,
  additionalSystemInstructions,
  messages,
  toolOptions: {
    tools,
    toolChoice
  },
  docBase,
  functionCalling,
  maxRetries,
  retryConfiguration,
  logger,
  metadata,
  maxCallsAllowed = MAX_CALLS
}) {
  return function askLlmToRespond({
    documentationRequest: {
      commands,
      functions
    },
    callCount = 0
  }) {
    const functionLimitReached = callCount >= maxCallsAllowed;
    const keywords = [...(commands !== null && commands !== void 0 ? commands : []), ...(functions !== null && functions !== void 0 ? functions : [])];
    const requestedDocumentation = docBase.getDocumentation(keywords);
    const fakeRequestDocsToolCall = createFakeTooCall(commands, functions);
    const availableTools = Object.keys(tools !== null && tools !== void 0 ? tools : {});
    const next$ = (0, _rxjs.merge)((0, _rxjs.of)({
      type: _inferenceCommon.OutputEventType.OutputComplete,
      id: 'request_documentation',
      output: {
        keywords,
        requestedDocumentation
      },
      content: ''
    }), chatCompleteApi({
      connectorId,
      functionCalling,
      maxRetries,
      retryConfiguration,
      metadata,
      stream: true,
      system: (0, _prompts.generateEsqlPrompt)({
        esqlPrompts: docBase.getPrompts(),
        additionalSystemInstructions,
        availableTools,
        hasTools: !functionLimitReached && Object.keys(tools !== null && tools !== void 0 ? tools : {}).length > 0
      }),
      messages: [...messages, {
        role: _inferenceCommon.MessageRole.Assistant,
        content: null,
        toolCalls: [fakeRequestDocsToolCall]
      }, {
        name: fakeRequestDocsToolCall.function.name,
        role: _inferenceCommon.MessageRole.Tool,
        response: {
          documentation: requestedDocumentation
        },
        toolCallId: fakeRequestDocsToolCall.toolCallId
      }],
      toolChoice: !functionLimitReached ? toolChoice : _inferenceCommon.ToolChoiceType.none,
      tools: functionLimitReached ? undefined : {
        ...tools,
        request_documentation: {
          description: 'Request additional ES|QL documentation if needed',
          schema: _shared.requestDocumentationSchema
        }
      }
    }).pipe((0, _inferenceCommon.withoutTokenCountEvents)(), (0, _rxjs.map)(generateEvent => {
      if ((0, _inferenceCommon.isChatCompletionMessageEvent)(generateEvent)) {
        return {
          ...generateEvent,
          content: generateEvent.content ? correctEsqlMistakes({
            content: generateEvent.content,
            logger
          }) : generateEvent.content
        };
      }
      return generateEvent;
    }), (0, _rxjs.switchMap)(generateEvent => {
      if ((0, _inferenceCommon.isChatCompletionMessageEvent)(generateEvent)) {
        const toolCalls = generateEvent.toolCalls;
        const onlyToolCall = toolCalls.length === 1 ? toolCalls[0] : undefined;
        if (onlyToolCall && onlyToolCall.function.name === 'request_documentation') {
          var _args$commands, _args$functions;
          if (functionLimitReached) {
            return (0, _rxjs.of)({
              ...generateEvent,
              content: `You have reached the maximum number of documentation requests. Do not try to request documentation again for commands ${commands === null || commands === void 0 ? void 0 : commands.join(', ')} and functions ${functions === null || functions === void 0 ? void 0 : functions.join(', ')}. Try to answer the user's question using currently available information.`
            });
          }
          const args = 'arguments' in onlyToolCall.function ? onlyToolCall.function.arguments : undefined;
          if (args && ((_args$commands = args.commands) !== null && _args$commands !== void 0 && _args$commands.length || (_args$functions = args.functions) !== null && _args$functions !== void 0 && _args$functions.length)) {
            var _args$commands2, _args$functions2;
            return askLlmToRespond({
              documentationRequest: {
                commands: (_args$commands2 = args.commands) !== null && _args$commands2 !== void 0 ? _args$commands2 : [],
                functions: (_args$functions2 = args.functions) !== null && _args$functions2 !== void 0 ? _args$functions2 : []
              },
              callCount: callCount + 1
            });
          }
        }
      }
      return (0, _rxjs.of)(generateEvent);
    })));
    return next$;
  };
}
const correctEsqlMistakes = ({
  content,
  logger
}) => {
  return content.replaceAll(_constants.INLINE_ESQL_QUERY_REGEX, (_match, query) => {
    const correction = (0, _common.correctCommonEsqlMistakes)(query);
    if (correction.isCorrection) {
      logger.debug(`Corrected query, from: \n${correction.input}\nto:\n${correction.output}`);
    }
    return '```esql\n' + correction.output + '\n```';
  });
};
const createFakeTooCall = (commands, functions) => {
  return {
    function: {
      name: 'request_documentation',
      arguments: {
        commands,
        functions
      }
    },
    toolCallId: (0, _common.generateFakeToolCallId)()
  };
};