"use strict";

var _tsd = require("tsd");
var _messages = require("../messages");
var _tools = require("../tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const minimalMessages = [{
  role: _messages.MessageRole.User,
  content: 'hello'
}];
const getWeatherToolDefinition = {
  schema: {
    type: 'object',
    properties: {
      location: {
        type: 'string'
      }
    },
    required: ['location']
  },
  description: 'Get weather'
};
const getStockPriceToolDefinition = {
  schema: {
    type: 'object',
    properties: {
      symbol: {
        type: 'string'
      }
    },
    required: ['symbol']
  },
  description: 'Get stock price'
};
const myTools = {
  get_weather: getWeatherToolDefinition,
  get_stock_price: getStockPriceToolDefinition
};

/**
 * No specified settings
 */

(0, _tsd.expectType)(defaultToolResponse);

/**
 * No tools
 */

(0, _tsd.expectType)(emptyToolResponse);

/**
 * Defined tools
 */

(0, _tsd.expectType)(specificToolResponse);
if (specificToolResponse.toolCalls && specificToolResponse.toolCalls.length > 0) {
  const firstToolCall = specificToolResponse.toolCalls[0];
  (0, _tsd.expectAssignable)(firstToolCall.function.name);
}

/**
 * stream: false = no streaming
 */

(0, _tsd.expectType)({});
/**
 * stream: false = streaming
 */

/**
 * stream: boolean = union
 */
(0, _tsd.expectType)({});
(0, _tsd.expectAssignable)({});

/**
 * tools inference for runtime code
 */
const resWithTools = mockApi({
  connectorId: 'c1',
  messages: minimalMessages,
  tools: {
    get_weather: getWeatherToolDefinition
  }
});

// defaults to non-streaming
(0, _tsd.expectType)(resWithTools);
resWithTools.then(r => {
  if (r.toolCalls) {
    (0, _tsd.expectType)(r.toolCalls[0].function.name);
  }
});

/**
 * tools inference for runtime code + stream: true
 */
const resStreamWithTools = mockApi({
  connectorId: 'c1',
  messages: minimalMessages,
  stream: true,
  tools: {
    get_weather: getWeatherToolDefinition
  }
});
(0, _tsd.expectType)(resStreamWithTools);

/**
 * toolChoice = none should be toolCalls:[]
 */

const resToolChoiceNone = mockApi({
  connectorId: 'c1',
  messages: minimalMessages,
  tools: {
    get_weather: getWeatherToolDefinition
  },
  toolChoice: _tools.ToolChoiceType.none
});
resToolChoiceNone.then(r => {
  (0, _tsd.expectType)(r.toolCalls);
});

/**
 * specific tool choice = only specified tool is typed
 */
const resToolChoiceSpecific = mockApi({
  connectorId: 'c1',
  messages: minimalMessages,
  tools: myTools,
  toolChoice: {
    type: 'function',
    function: 'get_weather'
  }
});
(0, _tsd.expectType)(resToolChoiceSpecific);
resToolChoiceSpecific.then(r => {
  if (r.toolCalls) {
    (0, _tsd.expectAssignable)(r.toolCalls);
  }
});