"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLifecyclePolicyConfirmModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _api = require("../../application/services/api");
var _api_errors = require("../../application/services/api_errors");
var _notification = require("../../application/services/notification");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/extend_index_management/components/add_lifecycle_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AddLifecyclePolicyConfirmModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "addPolicy", async () => {
      const {
        indexName,
        closeModal,
        reloadIndices
      } = this.props;
      const {
        selectedPolicyName,
        selectedAlias
      } = this.state;
      if (!selectedPolicyName) {
        this.setState({
          policyErrorMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.noPolicySelectedErrorMessage', {
            defaultMessage: 'You must select a policy.'
          })
        });
        return;
      }
      try {
        const body = {
          indexName,
          policyName: selectedPolicyName,
          alias: selectedAlias
        };
        await (0, _api.addLifecyclePolicyToIndex)(body);
        closeModal();
        _notification.toasts.addSuccess(_i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyToIndexSuccess', {
          defaultMessage: 'Added policy {policyName} to index {indexName}.',
          values: {
            policyName: selectedPolicyName,
            indexName
          }
        }));
        reloadIndices();
      } catch (err) {
        (0, _api_errors.showApiError)(err, _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyToIndexError', {
          defaultMessage: 'Error adding policy to index'
        }));
      }
    });
    (0, _defineProperty2.default)(this, "renderAliasFormElement", selectedPolicy => {
      const {
        selectedAlias
      } = this.state;
      const {
        index
      } = this.props;
      const showAliasSelect = selectedPolicy && (0, _lodash.get)(selectedPolicy, 'policy.phases.hot.actions.rollover');
      if (!showAliasSelect) {
        return null;
      }
      const {
        aliases
      } = index;
      if (aliases === 'none') {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          style: {
            maxWidth: 400
          },
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.indexHasNoAliasesWarningTitle",
            defaultMessage: "Index has no aliases",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 122,
              columnNumber: 15
            }
          }),
          color: "warning",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.indexHasNoAliasesWarningMessage",
          defaultMessage: "Policy {policyName} is configured for rollover, but index {indexName} does not have an alias, which is required for rollover.",
          values: {
            policyName: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.name,
            indexName: index.name
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 129,
            columnNumber: 13
          }
        })));
      }
      const aliasOptions = aliases.map(alias => {
        return {
          text: alias,
          value: alias
        };
      });
      aliasOptions.unshift({
        text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.chooseAliasMessage', {
          defaultMessage: 'Choose an alias'
        }),
        value: ''
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.chooseAliasLabel",
          defaultMessage: "Index rollover alias",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 160,
            columnNumber: 11
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        options: aliasOptions,
        value: selectedAlias,
        onChange: e => {
          this.setState({
            selectedAlias: e.target.value
          });
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 9
        }
      }));
    });
    this.state = {
      policies: [],
      selectedPolicyName: '',
      selectedAlias: '',
      isLoading: true
    };
  }
  renderForm() {
    const {
      policies,
      selectedPolicyName,
      policyErrorMessage
    } = this.state;
    const selectedPolicy = selectedPolicyName ? policies.find(policy => policy.name === selectedPolicyName) : undefined;
    const options = policies.map(({
      name
    }) => {
      return {
        value: name,
        text: name
      };
    });
    options.unshift({
      value: '',
      text: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.choosePolicyMessage', {
        defaultMessage: 'Select a lifecycle policy'
      })
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: !!policyErrorMessage,
      error: policyErrorMessage,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.choosePolicyLabel",
        defaultMessage: "Lifecycle policy",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      isInvalid: !!policyErrorMessage,
      options: options,
      value: selectedPolicyName,
      onChange: e => {
        this.setState({
          policyErrorMessage: undefined,
          selectedPolicyName: e.target.value
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 11
      }
    })), this.renderAliasFormElement(selectedPolicy));
  }
  async componentDidMount() {
    try {
      const policies = await (0, _api.loadPolicies)();
      this.setState({
        policies,
        isLoading: false
      });
    } catch (err) {
      (0, _api_errors.showApiError)(err, _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.loadPolicyError', {
        defaultMessage: 'Error loading policy list'
      }));
      this.props.closeModal();
    }
  }
  render() {
    const {
      policies,
      isLoading
    } = this.state;
    const {
      indexName,
      closeModal,
      getUrlForApp
    } = this.props;
    const idGenerator = (0, _eui.htmlIdGenerator)();
    const modalTitleId = idGenerator('modal');
    const confirmModalId = idGenerator('confirmModal');
    const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.modalTitle",
      defaultMessage: "Add lifecycle policy to \"{indexName}\"",
      values: {
        indexName
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 7
      }
    });
    if (!isLoading && !policies.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
        onClose: closeModal,
        "aria-labelledby": modalTitleId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 257,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 258,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
        id: modalTitleId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 13
        }
      }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        style: {
          maxWidth: 400
        },
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.noPoliciesWarningTitle",
          defaultMessage: "No index lifecycle policies defined",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 266,
            columnNumber: 17
          }
        }),
        color: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getUrlForApp('management', {
          path: `data/index_lifecycle_management/policies/edit`
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.defineLifecyclePolicyLinkText",
        defaultMessage: "Define lifecycle policy",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 279,
          columnNumber: 19
        }
      }))))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalId,
      title: title,
      titleProps: {
        id: confirmModalId
      },
      onCancel: closeModal,
      onConfirm: this.addPolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.cancelButtonText",
        defaultMessage: "Cancel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 11
        }
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyButtonText",
        defaultMessage: "Add policy",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 11
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 7
      }
    }, this.renderForm());
  }
}
exports.AddLifecyclePolicyConfirmModal = AddLifecyclePolicyConfirmModal;