"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addLifecyclePolicyToTemplate = exports.addLifecyclePolicyToIndex = void 0;
exports.deletePolicy = deletePolicy;
exports.loadPolicies = loadPolicies;
exports.retryLifecycleForIndex = exports.removeLifecycleForIndex = void 0;
exports.savePolicy = savePolicy;
exports.useLoadSnapshotRepositories = exports.useLoadSnapshotPolicies = exports.useLoadPoliciesList = exports.useLoadNodes = exports.useLoadNodeDetails = exports.useLoadIndexTemplates = void 0;
var _analytics = require("@kbn/analytics");
var _constants = require("../constants");
var _ui_metric = require("./ui_metric");
var _http = require("./http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLoadNodes = () => {
  return (0, _http.useRequest)({
    path: `nodes/list`,
    method: 'get',
    initialData: {
      nodesByAttributes: {},
      nodesByRoles: {}
    }
  });
};
exports.useLoadNodes = useLoadNodes;
const useLoadNodeDetails = selectedNodeAttrs => {
  return (0, _http.useRequest)({
    path: `nodes/${selectedNodeAttrs}/details`,
    method: 'get'
  });
};
exports.useLoadNodeDetails = useLoadNodeDetails;
const useLoadIndexTemplates = (legacy = false) => {
  return (0, _http.useRequest)({
    path: 'templates',
    query: {
      legacy
    },
    method: 'get',
    initialData: []
  });
};
exports.useLoadIndexTemplates = useLoadIndexTemplates;
async function loadPolicies() {
  return await (0, _http.sendGet)('policies');
}
const useLoadPoliciesList = () => {
  return (0, _http.useRequest)({
    path: `policies`,
    method: 'get'
  });
};
exports.useLoadPoliciesList = useLoadPoliciesList;
async function savePolicy(policy) {
  return await (0, _http.sendPost)(`policies`, policy);
}
async function deletePolicy(policyName) {
  const response = await (0, _http.sendDelete)(`policies/${encodeURIComponent(policyName)}`);
  // Only track successful actions.
  (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.COUNT, _constants.UIM_POLICY_DELETE);
  return response;
}
const retryLifecycleForIndex = async indexNames => {
  const response = await (0, _http.sendPost)(`index/retry`, {
    indexNames
  });
  // Only track successful actions.
  (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.COUNT, _constants.UIM_INDEX_RETRY_STEP);
  return response;
};
exports.retryLifecycleForIndex = retryLifecycleForIndex;
const removeLifecycleForIndex = async indexNames => {
  const response = await (0, _http.sendPost)(`index/remove`, {
    indexNames
  });
  // Only track successful actions.
  (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.COUNT, _constants.UIM_POLICY_DETACH_INDEX);
  return response;
};
exports.removeLifecycleForIndex = removeLifecycleForIndex;
const addLifecyclePolicyToIndex = async body => {
  const response = await (0, _http.sendPost)(`index/add`, body);
  // Only track successful actions.
  (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.COUNT, _constants.UIM_POLICY_ATTACH_INDEX);
  return response;
};
exports.addLifecyclePolicyToIndex = addLifecyclePolicyToIndex;
const addLifecyclePolicyToTemplate = async (body, legacy = false) => {
  const response = await (0, _http.sendPost)(`template`, body, {
    legacy
  });
  // Only track successful actions.
  (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.COUNT, _constants.UIM_POLICY_ATTACH_INDEX_TEMPLATE);
  return response;
};
exports.addLifecyclePolicyToTemplate = addLifecyclePolicyToTemplate;
const useLoadSnapshotPolicies = () => {
  return (0, _http.useRequest)({
    path: `snapshot_policies`,
    method: 'get',
    initialData: []
  });
};
exports.useLoadSnapshotPolicies = useLoadSnapshotPolicies;
const useLoadSnapshotRepositories = () => {
  return (0, _http.useRequest)({
    path: `snapshot_repositories`,
    method: 'get'
  });
};
exports.useLoadSnapshotRepositories = useLoadSnapshotRepositories;