"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultRepository = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultRepository = configs => {
  var _configs$;
  if (configs.length === 0) {
    return '';
  }
  if (Boolean((_configs$ = configs[0]) === null || _configs$ === void 0 ? void 0 : _configs$.snapshot_repository)) {
    return configs[0].snapshot_repository;
  }
  return getDefaultRepository(configs.slice(1));
};
exports.getDefaultRepository = getDefaultRepository;