"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticManagedLlmConnector = exports.INFERENCE_CONNECTOR_ACTION_TYPE_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFERENCE_CONNECTOR_ACTION_TYPE_ID = exports.INFERENCE_CONNECTOR_ACTION_TYPE_ID = '.inference';
const getElasticManagedLlmConnector = connectors => {
  if (!Array.isArray(connectors) || connectors.length === 0) {
    return undefined;
  }
  return connectors.find(connector => {
    var _connector$config;
    return connector.actionTypeId === INFERENCE_CONNECTOR_ACTION_TYPE_ID && connector.isPreconfigured && ((_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : _connector$config.provider) === 'elastic';
  });
};
exports.getElasticManagedLlmConnector = getElasticManagedLlmConnector;