"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateSingleAgentHandler = exports.bulkMigrateAgentsHandler = void 0;
var AgentService = _interopRequireWildcard(require("../../services/agents"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateSingleAgentHandler = async (context, request, response) => {
  const [coreContext] = await Promise.all([context.core, context.fleet]);
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const soClient = coreContext.savedObjects.client;
  const options = request.body;

  // First validate the agent exists
  const agent = await AgentService.getAgentById(esClient, soClient, request.params.agentId);
  // Using the agent id, get the agent policy
  const agentPolicy = await AgentService.getAgentPolicyForAgent(soClient, esClient, request.params.agentId);
  const body = await AgentService.migrateSingleAgent(esClient, soClient, request.params.agentId, agentPolicy, agent, {
    ...options,
    policyId: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id
  });
  return response.ok({
    body
  });
};
exports.migrateSingleAgentHandler = migrateSingleAgentHandler;
const bulkMigrateAgentsHandler = async (context, request, response) => {
  const [coreContext] = await Promise.all([context.core, context.fleet]);
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const soClient = coreContext.savedObjects.client;
  const {
    agents,
    ...options
  } = request.body;
  const agentOptions = Array.isArray(agents) ? {
    agentIds: agents
  } : {
    kuery: agents
  };
  const body = await AgentService.bulkMigrateAgents(esClient, soClient, {
    ...options,
    ...agentOptions
  });
  return response.ok({
    body
  });
};
exports.bulkMigrateAgentsHandler = bulkMigrateAgentsHandler;