"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendDeleteOutput = sendDeleteOutput;
exports.sendGetOneOutput = sendGetOneOutput;
exports.sendGetOutputHealth = sendGetOutputHealth;
exports.sendGetRemoteSyncedIntegrationsStatus = sendGetRemoteSyncedIntegrationsStatus;
exports.sendPostLogstashApiKeys = sendPostLogstashApiKeys;
exports.sendPostOutput = sendPostOutput;
exports.sendPutOutput = sendPutOutput;
exports.useDefaultOutput = useDefaultOutput;
exports.useGetOutputs = useGetOutputs;
exports.useGetRemoteSyncedIntegrationsStatusQuery = useGetRemoteSyncedIntegrationsStatusQuery;
var _reactQuery = require("@tanstack/react-query");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetOutputs() {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.outputRoutesService.getListPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function useDefaultOutput() {
  var _outputsRequest$data;
  const outputsRequest = useGetOutputs();
  const output = (_outputsRequest$data = outputsRequest.data) === null || _outputsRequest$data === void 0 ? void 0 : _outputsRequest$data.items.find(o => o.is_default);
  return {
    output,
    refresh: outputsRequest.resendRequest
  };
}
function sendGetOneOutput(outputId) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.outputRoutesService.getInfoPath(outputId),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendPutOutput(outputId, body) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.outputRoutesService.getUpdatePath(outputId),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}
function sendPostLogstashApiKeys() {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.outputRoutesService.getCreateLogstashApiKeyPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendPostOutput(body) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.outputRoutesService.getCreatePath(),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}
function sendDeleteOutput(outputId) {
  return (0, _use_request.sendRequest)({
    method: 'delete',
    path: _services.outputRoutesService.getDeletePath(outputId),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendGetOutputHealth(outputId) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.outputRoutesService.getOutputHealthPath(outputId),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendGetRemoteSyncedIntegrationsStatus(outputId) {
  return (0, _use_request.sendRequestForRq)({
    method: 'get',
    path: _services.outputRoutesService.getRemoteSyncedIntegrationsStatusPath(outputId),
    version: _constants.API_VERSIONS.public.v1
  });
}
const SYNC_STATUS_REFETCH_INTERVAL = 10000;
function useGetRemoteSyncedIntegrationsStatusQuery(outputId, options = {}) {
  return (0, _reactQuery.useQuery)([`remote_synced_integrations_status_${outputId}`], () => sendGetRemoteSyncedIntegrationsStatus(outputId), {
    enabled: options.enabled,
    refetchInterval: SYNC_STATUS_REFETCH_INTERVAL,
    retry: false
  });
}