"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureArmTemplateInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("./hooks");
var _azure_arm_template_guide = require("./azure_arm_template_guide");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/cloud_security_posture/azure_arm_template_instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AzureArmTemplateInstructions = ({
  enrollmentAPIKey,
  cloudSecurityIntegration,
  agentPolicy
}) => {
  var _cloudSecurityIntegra;
  const {
    isLoading,
    azureArmTemplateUrl,
    error,
    isError
  } = (0, _hooks.useCreateAzureArmTemplateUrl)({
    enrollmentAPIKey,
    azureArmTemplateProps: cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.azureArmTemplateProps
  });
  if (error && isError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: error,
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "m",
    isLoading: isLoading || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.isLoading),
    contentAriaLabel: _i18n.i18n.translate('xpack.fleet.agentEnrollment.azureArmTemplate.loadingAriaLabel', {
      defaultMessage: 'Loading ARM Template instructions'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_azure_arm_template_guide.AzureArmTemplateGuide, {
    azureAccountType: cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : (_cloudSecurityIntegra = cloudSecurityIntegration.azureArmTemplateProps) === null || _cloudSecurityIntegra === void 0 ? void 0 : _cloudSecurityIntegra.azureAccountType,
    agentPolicy: agentPolicy,
    enrollmentToken: enrollmentAPIKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    fullWidth: true,
    href: azureArmTemplateUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.azureArmTemplate.launchButton",
    defaultMessage: "Launch ARM Template",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })));
};
exports.AzureArmTemplateInstructions = AzureArmTemplateInstructions;