"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrereleaseCallout = exports.OtelPackageCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
var _services = require("../../../../../../../../common/services");
var _otelcol_helpers = require("../../../../../../../../common/services/otelcol_helpers");
var _services2 = require("../../../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/overview/prerelease_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PrereleaseCallout = ({
  packageInfo,
  latestGAVersion
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    enableOtelIntegrations
  } = _services2.ExperimentalFeaturesService.get();
  const {
    name,
    title
  } = packageInfo;
  const overviewPathLatestGA = getHref('integration_details_overview', {
    pkgkey: `${name}-${latestGAVersion}`
  });
  const isPrerelease = (0, _services.isPackagePrerelease)(packageInfo.version);
  if (!isPrerelease) return null;
  if (enableOtelIntegrations && (0, _otelcol_helpers.packageInfoHasOtelInputs)(packageInfo)) {
    return /*#__PURE__*/_react.default.createElement(OtelPackageCallout, {
      packageInfo: packageInfo,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    "data-test-subj": "prereleaseCallout",
    title: _i18n.i18n.translate('xpack.fleet.epm.prereleaseWarningCalloutTitle', {
      defaultMessage: 'This is a pre-release version of {packageTitle} integration.',
      values: {
        packageTitle: title
      }
    }),
    iconType: "info",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, latestGAVersion && /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: overviewPathLatestGA,
    color: "warning",
    "data-test-subj": "switchToGABtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.prereleaseWarningCalloutSwitchToGAButton",
    defaultMessage: "Switch to latest GA version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 15
    }
  })))));
};
exports.PrereleaseCallout = PrereleaseCallout;
const OtelPackageCallout = ({
  packageInfo
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const packageTitle = packageInfo.title;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    "data-test-subj": "prereleaseCallout",
    title: _i18n.i18n.translate('xpack.fleet.epm.otelPackageWarningTitle', {
      defaultMessage: 'This is a pre-release version of {packageTitle} integration.',
      values: {
        packageTitle
      }
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.otelPackageWarningMessage",
    defaultMessage: "The {packageTitle} integration collects {OTelExternalLink} data adhering to {semanticConventionsLink}, and is available in technical preview. To collect OTel data, Elastic Agents must be on version {minVersion} or later. For more information, refer to the {fleetUserGuide}.",
    values: {
      packageTitle,
      OTelExternalLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://opentelemetry.io/",
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.fleet.settings.otelPackageWarning.OtelLinkLabel', {
        defaultMessage: 'OpenTelemetry'
      })),
      semanticConventionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://opentelemetry.io/docs/concepts/semantic-conventions/",
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.fleet.settings.otelPackageWarning.semanticConventionsLinkLabel', {
        defaultMessage: 'semantic conventions'
      })),
      fleetUserGuide: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.edotCollector,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.fleet.epm.otelPackageWarningMessage.fleetUserGuideLabel', {
        defaultMessage: 'user guide'
      })),
      minVersion: _otelcol_helpers.OTEL_INPUTS_MINIMUM_VERSION
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))));
};
exports.OtelPackageCallout = OtelPackageCallout;