"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeferredInstallationMsg = exports.DeferredAssetsWarning = exports.DEFERRED_ASSETS_WARNING_MSG = exports.DEFERRED_ASSETS_WARNING_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/assets/deferred_assets_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFERRED_ASSETS_WARNING_LABEL = exports.DEFERRED_ASSETS_WARNING_LABEL = _i18n.i18n.translate('xpack.fleet.packageCard.reauthorizationRequiredLabel', {
  defaultMessage: 'Reauthorization required'
});
const DEFERRED_ASSETS_WARNING_MSG = exports.DEFERRED_ASSETS_WARNING_MSG = _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredInstallationsMsg', {
  defaultMessage: 'This package has at least one deferred installation which requires additional permissions to install and operate correctly.'
});
const getDeferredInstallationMsg = (numOfDeferredInstallations, {
  authz
}) => {
  var _authz$packagePrivile, _authz$packagePrivile2, _authz$packagePrivile3, _authz$packagePrivile4, _authz$packagePrivile5;
  const canReauthorizeTransforms = (_authz$packagePrivile = authz === null || authz === void 0 ? void 0 : (_authz$packagePrivile2 = authz.packagePrivileges) === null || _authz$packagePrivile2 === void 0 ? void 0 : (_authz$packagePrivile3 = _authz$packagePrivile2.transform) === null || _authz$packagePrivile3 === void 0 ? void 0 : (_authz$packagePrivile4 = _authz$packagePrivile3.actions) === null || _authz$packagePrivile4 === void 0 ? void 0 : (_authz$packagePrivile5 = _authz$packagePrivile4.canStartStopTransform) === null || _authz$packagePrivile5 === void 0 ? void 0 : _authz$packagePrivile5.executePackageAction) !== null && _authz$packagePrivile !== void 0 ? _authz$packagePrivile : false;
  if (!numOfDeferredInstallations) return DEFERRED_ASSETS_WARNING_MSG;
  if (canReauthorizeTransforms) {
    return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.reauthorizeDeferredInstallationsMsg', {
      defaultMessage: 'This package has {numOfDeferredInstallations, plural, one {one deferred installation} other {# deferred installations}}. Complete the installation to operate the package correctly.',
      values: {
        numOfDeferredInstallations
      }
    });
  }
  return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredInstallationsWarning', {
    defaultMessage: 'This package has {numOfDeferredInstallations, plural, one {one deferred installation which requires} other {# deferred installations which require}} additional permissions to install and operate correctly.',
    values: {
      numOfDeferredInstallations
    }
  });
};
exports.getDeferredInstallationMsg = getDeferredInstallationMsg;
const DeferredAssetsWarning = ({
  numOfDeferredInstallations
}) => {
  const authz = (0, _hooks.useAuthz)();
  const tooltipContent = (0, _react.useMemo)(() => getDeferredInstallationMsg(numOfDeferredInstallations, {
    authz
  }), [numOfDeferredInstallations, authz]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    display: "inlineBlock",
    content: tooltipContent,
    title: DEFERRED_ASSETS_WARNING_LABEL,
    type: 'alert',
    color: 'warning',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  });
};
exports.DeferredAssetsWarning = DeferredAssetsWarning;