"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreconfigurationDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _constants = require("../../../constants");
var _ = require("..");
var _code_block = require("./code_block");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/preconfiguration_debugger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchPreconfiguredPolicies = async () => {
  var _response$data$items, _response$data;
  const kuery = `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.is_preconfigured:true`;
  const response = await (0, _hooks.sendGetAgentPolicies)({
    kuery,
    perPage: 100,
    full: true
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  return (_response$data$items = (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items) !== null && _response$data$items !== void 0 ? _response$data$items : [];
};
const PreconfigurationDebugger = () => {
  var _preconfiguredPolicie, _preconfiguredPolicie2, _preconfiguredPolicie3, _preconfiguredPolicie4;
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)();
  const [isResetModalVisible, setIsResetModalVisible] = (0, _react.useState)(false);
  const [isResetAllModalVisible, setIsResetAllModalVisible] = (0, _react.useState)(false);
  const preconfiguredPolicies = (0, _reactQuery.useQuery)(['debug-preconfigured-policies'], fetchPreconfiguredPolicies);
  const comboBoxOptions = (_preconfiguredPolicie = (_preconfiguredPolicie2 = preconfiguredPolicies.data) === null || _preconfiguredPolicie2 === void 0 ? void 0 : _preconfiguredPolicie2.map(policy => ({
    label: policy.name,
    value: policy.id
  }))) !== null && _preconfiguredPolicie !== void 0 ? _preconfiguredPolicie : [];
  const selectedOptions = selectedPolicyId ? [comboBoxOptions.find(({
    value
  }) => value === selectedPolicyId)] : [];
  const selectedPolicy = (_preconfiguredPolicie3 = preconfiguredPolicies.data) === null || _preconfiguredPolicie3 === void 0 ? void 0 : _preconfiguredPolicie3.find(policy => policy.id === selectedPolicyId);
  const resetOnePolicyMutation = (0, _reactQuery.useMutation)(async policyId => {
    const response = await (0, _hooks.sendResetOnePreconfiguredAgentPolicy)(policyId);
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetError', {
          defaultMessage: 'Error resetting policy'
        }),
        toastMessage: response.error.message
      });
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetSuccess', {
      defaultMessage: 'Successfully reset policy'
    }));
    _.queryClient.invalidateQueries(['debug-preconfigured-policies']);
    setSelectedPolicyId(undefined);
    setIsResetModalVisible(false);
    return response.data;
  });
  const resetAllPoliciesMutation = (0, _reactQuery.useMutation)(async () => {
    const response = await (0, _hooks.sendResetAllPreconfiguredAgentPolicies)();
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllError', {
          defaultMessage: 'Error resetting policies'
        }),
        toastMessage: response.error.message
      });
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllSuccess', {
      defaultMessage: 'Successfully reset policies'
    }));
    _.queryClient.invalidateQueries(['debug-preconfigured-policies']);
    setSelectedPolicyId(undefined);
    setIsResetAllModalVisible(false);
    return response.data;
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.description",
    defaultMessage: "This tool can be used to reset preconfigured policies that are managed via {codeKibanaYml}. This includes Fleet's default policies that may exist in cloud environments.",
    values: {
      codeKibanaYml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 38
        }
      }, "kibana.yml")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetInstructions",
    defaultMessage: "You may reset a single preconfigured policy or use the \"Reset all\" button to reset all preconfigured policies at once.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 400px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.selectLabel', {
      defaultMessage: 'Select a preconfigured policy'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.selectLabel', {
      defaultMessage: 'Select a preconfigured policy'
    }),
    fullWidth: true,
    options: comboBoxOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    onChange: newSelectedOptions => {
      if (!newSelectedOptions.length) {
        setSelectedPolicyId(undefined);
      } else {
        setSelectedPolicyId(newSelectedOptions[0].value);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    isDisabled: !selectedPolicyId,
    onClick: () => setIsResetModalVisible(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetButton",
    defaultMessage: "Reset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    isDisabled: !((_preconfiguredPolicie4 = preconfiguredPolicies.data) !== null && _preconfiguredPolicie4 !== void 0 && _preconfiguredPolicie4.length),
    onClick: () => setIsResetAllModalVisible(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetAllButton",
    defaultMessage: "Reset all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }))))), isResetModalVisible && selectedPolicy && selectedPolicyId && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetModalTitle', {
      defaultMessage: 'Reset {policyName}',
      values: {
        policyName: selectedPolicy.name
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsResetModalVisible(false),
    onConfirm: () => resetOnePolicyMutation.mutate(selectedPolicyId),
    isLoading: resetOnePolicyMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetModalCancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetModalConfirm', {
      defaultMessage: 'Reset'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetModalBody",
    defaultMessage: "Are you sure you want to reset {policyName}?",
    values: {
      policyName: selectedPolicy.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  })), isResetAllModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllModalTitle', {
      defaultMessage: 'Reset all preconfigured policies'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsResetAllModalVisible(false),
    onConfirm: () => resetAllPoliciesMutation.mutate(),
    isLoading: resetAllPoliciesMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllModalCancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.preconfigurationDebugger.resetAllModalConfirm', {
      defaultMessage: 'Reset all'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.resetAllModalBody",
    defaultMessage: "Are you sure you want to reset all preconfigured policies?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  })), selectedPolicyId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: getHref('policy_details', {
      policyId: selectedPolicyId
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.preconfigurationDebugger.viewAgentPolicyLink",
    defaultMessage: "View Agent Policy in Fleet UI",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_block.CodeBlock, {
    value: JSON.stringify(selectedPolicy, null, 2),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 11
    }
  })));
};
exports.PreconfigurationDebugger = PreconfigurationDebugger;