"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAgentPolicyOrDefault = useGetAgentPolicyOrDefault;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _generate_new_agent_policy = require("../../../../../../../../common/services/generate_new_agent_policy");
var _hooks = require("../../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Manual default space ID because importing from `@kbn/core-saved-objects-utils-server` is not allowed here
const DEFAULT_NAMESPACE_STRING = 'default';
const sendGetAgentPolicy = async agentPolicyId => {
  var _result;
  let result;
  let error;
  try {
    result = await (0, _hooks.sendGetOneAgentPolicy)(agentPolicyId);
    if (result.error) {
      error = result.error;
    }
  } catch (e) {
    error = e;
  }
  if (error && error.statusCode !== 404) {
    return {
      error
    };
  }
  return {
    data: (_result = result) === null || _result === void 0 ? void 0 : _result.data
  };
};
function useGetAgentPolicyOrDefault(agentPolicyIdIn) {
  const {
    spaceId,
    isSpaceAwarenessEnabled
  } = (0, _hooks.useFleetStatus)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [error, setError] = (0, _react.useState)();
  const [agentPolicyResponse, setAgentPolicyResponse] = (0, _react.useState)();
  const [enrollmentAPIKey, setEnrollmentAPIKey] = (0, _react.useState)();
  const [created, setCreated] = (0, _react.useState)();

  // If space awareness is enabled, append current space ID to the agent policy ID
  // If current space is the default space, do not append the space ID for BWC
  const defaultFirstPolicyIdBase = 'fleet-first-agent-policy';
  const defaultFirstPolicyId = (0, _react.useMemo)(() => isSpaceAwarenessEnabled && spaceId !== DEFAULT_NAMESPACE_STRING ? `${spaceId}:${defaultFirstPolicyIdBase}` : defaultFirstPolicyIdBase, [isSpaceAwarenessEnabled, spaceId]);
  const defaultFirstPolicy = (0, _react.useMemo)(() => Object.freeze((0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
    id: defaultFirstPolicyId,
    name: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.firstAgentPolicyNameText', {
      defaultMessage: 'My first agent policy'
    })
  })), [defaultFirstPolicyId]);
  (0, _react.useEffect)(() => {
    const getAgentPolicyOrDefault = async () => {
      var _apiKeysData$items;
      setIsLoading(true);
      const agentPolicyId = agentPolicyIdIn || defaultFirstPolicyId;
      const {
        data: agentPolicyData,
        error: getError
      } = await sendGetAgentPolicy(agentPolicyId);
      const existingAgentPolicy = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.item;
      if (agentPolicyIdIn && !existingAgentPolicy) {
        setIsLoading(false);
        setError(new Error(`Agent policy ${agentPolicyId} not found`));
        return;
      }
      let createdAgentPolicy;
      if (getError) {
        setIsLoading(false);
        setError(getError);
        return;
      }
      if (!existingAgentPolicy) {
        const {
          data: createdAgentPolicyData,
          error: createError
        } = await _hooks.sendCreateAgentPolicy.bind(null, defaultFirstPolicy)();
        if (createError) {
          setIsLoading(false);
          setError(createError);
          return;
        }
        createdAgentPolicy = createdAgentPolicyData.item;
        setCreated(true);
      }
      const agentPolicy = existingAgentPolicy || createdAgentPolicy;
      setAgentPolicyResponse(agentPolicy);
      const {
        data: apiKeysData,
        error: apiKeysError
      } = await (0, _hooks.sendGetEnrollmentAPIKeys)({
        page: 1,
        perPage: 1,
        kuery: `policy_id:"${agentPolicyId}"`
      });
      if (apiKeysError) {
        setIsLoading(false);
        setError(apiKeysError);
        return;
      }
      if (!apiKeysData || !((_apiKeysData$items = apiKeysData.items) !== null && _apiKeysData$items !== void 0 && _apiKeysData$items.length)) {
        setIsLoading(false);
        setError(new Error(`No enrollment API key found for policy ${agentPolicyId}`));
        return;
      }
      setIsLoading(false);
      setEnrollmentAPIKey(apiKeysData.items[0]);
    };
    getAgentPolicyOrDefault();
  }, [agentPolicyIdIn, defaultFirstPolicy, defaultFirstPolicyId]);
  return {
    isLoading,
    error,
    agentPolicy: agentPolicyResponse,
    enrollmentAPIKey,
    created
  };
}