"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortDatastreamsByDataset = sortDatastreamsByDataset;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// sort data streams by dataset name, but promote datastreams that are from this package to the start
function sortDatastreamsByDataset(datasetList, name) {
  const [relevantDatasets, otherDatasets] = (0, _lodash.partition)((0, _lodash.sortBy)(datasetList, 'dataset'), record => record.dataset.startsWith(name));
  const datasets = relevantDatasets.concat(otherDatasets);
  return datasets;
}