"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyAdvancedMonitoringOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_advanced_fields/advanced_monitoring.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  margin-block-start: ${props => props.theme.eui.euiSizeS};
  .ingest-active-button {
    color: ${props => props.theme.eui.euiColorPrimary};
  }
`;
const PushedDescribedFormGroup = (0, _styledComponents.default)(_eui.EuiDescribedFormGroup)`
  h3,
  .euiDescribedFormGroup__description {
    padding-left: ${props => props.theme.eui.euiSizeL};
  }
`;
const AgentPolicyAdvancedMonitoringOptions = ({
  agentPolicy,
  disabled,
  validation,
  touchedFields,
  updateTouchedFields,
  updateAgentPolicy
}) => {
  var _agentPolicy$monitori, _agentPolicy$monitori4, _agentPolicy$monitori5, _agentPolicy$monitori6, _agentPolicy$monitori7, _agentPolicy$monitori8, _agentPolicy$monitori9, _agentPolicy$monitori10, _agentPolicy$monitori11, _agentPolicy$monitori12, _agentPolicy$monitori14, _agentPolicy$monitori15, _agentPolicy$monitori17, _agentPolicy$monitori18, _agentPolicy$monitori20, _agentPolicy$monitori21, _agentPolicy$monitori23, _agentPolicy$monitori24;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "advancedMonitoringOptions",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.advancedMonitoringOptionsToggleLabel",
      defaultMessage: "Advanced monitoring options",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }),
    buttonClassName: disabled ? undefined : 'ingest-active-button',
    isDisabled: disabled === true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(PushedDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringHttpLabel",
      defaultMessage: "HTTP monitoring endpoint",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringHttpDescription",
      defaultMessage: "Enable a liveness HTTP endpoint that returns the overall health of Elastic Agent. This can be used by Kubernetes to restart the container, for example. {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.httpMonitoring,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyForm.monitoringHttpDescription.learnMoreLinkLabel",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "httpMonitoringEnabled",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.enableHttpMonitoringLabel",
      defaultMessage: "Enable HTTP endpoint at {monitoringEndpoint}",
      values: {
        monitoringEndpoint: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 111,
            columnNumber: 37
          }
        }, "/liveness")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    }),
    disabled: disabled,
    checked: (_agentPolicy$monitori = agentPolicy.monitoring_http) === null || _agentPolicy$monitori === void 0 ? void 0 : _agentPolicy$monitori.enabled,
    onChange: e => {
      var _agentPolicy$monitori2, _agentPolicy$monitori3;
      const isEnabled = e.target.checked;
      const host = isEnabled && !((_agentPolicy$monitori2 = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori2 !== void 0 && _agentPolicy$monitori2.host) ? 'localhost' : undefined;
      const port = isEnabled && !((_agentPolicy$monitori3 = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori3 !== void 0 && _agentPolicy$monitori3.port) ? 6791 : undefined;
      updateTouchedFields({
        'monitoring_http.enabled': true
      });
      updateAgentPolicy({
        monitoring_http: {
          ...agentPolicy.monitoring_http,
          ...(host ? {
            host
          } : {}),
          ...(port ? {
            port
          } : {}),
          enabled: isEnabled
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringHttp.hostFieldLabel",
      defaultMessage: "Host",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 17
      }
    }),
    isDisabled: disabled || !((_agentPolicy$monitori4 = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori4 !== void 0 && _agentPolicy$monitori4.enabled),
    error: touchedFields['monitoring_http.host'] && validation['monitoring_http.host'] ? validation['monitoring_http.host'] : null,
    isInvalid: Boolean(touchedFields['monitoring_http.host'] && validation['monitoring_http.host']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    disabled: disabled || !((_agentPolicy$monitori5 = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori5 !== void 0 && _agentPolicy$monitori5.enabled),
    placeholder: "localhost",
    value: (_agentPolicy$monitori6 = agentPolicy.monitoring_http) === null || _agentPolicy$monitori6 === void 0 ? void 0 : _agentPolicy$monitori6.host,
    onChange: e => {
      updateAgentPolicy({
        monitoring_http: {
          ...agentPolicy.monitoring_http,
          host: e.target.value
        }
      });
    },
    onBlur: () => updateTouchedFields({
      'monitoring_http.host': true
    }),
    isInvalid: Boolean(touchedFields['monitoring_http.host'] && validation['monitoring_http.host']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringHttp.portFieldLabel",
      defaultMessage: "Port",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 17
      }
    }),
    isDisabled: disabled || !((_agentPolicy$monitori7 = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori7 !== void 0 && _agentPolicy$monitori7.enabled),
    error: touchedFields['monitoring_http.port'] && validation['monitoring_http.port'] ? validation['monitoring_http.port'] : null,
    isInvalid: Boolean(touchedFields['monitoring_http.port'] && validation['monitoring_http.port']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: disabled || !((_agentPolicy$monitori8 = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori8 !== void 0 && _agentPolicy$monitori8.enabled),
    placeholder: "6791",
    min: 1,
    max: 65535,
    value: (_agentPolicy$monitori9 = agentPolicy.monitoring_http) === null || _agentPolicy$monitori9 === void 0 ? void 0 : _agentPolicy$monitori9.port,
    onChange: e => {
      updateAgentPolicy({
        monitoring_http: {
          ...agentPolicy.monitoring_http,
          port: e.target.value ? Number(e.target.value) : 0
        }
      });
    },
    onBlur: () => updateTouchedFields({
      'monitoring_http.port': true
    }),
    isInvalid: Boolean(touchedFields['monitoring_http.port'] && validation['monitoring_http.port']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "httpMonitoringProfilingEnabled",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.enableHttpMonitoringPprofLabel",
      defaultMessage: "Enable profiling at {profilingEndpoint}",
      values: {
        profilingEndpoint: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 229,
            columnNumber: 36
          }
        }, "/debug/pprof")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 13
      }
    }),
    disabled: disabled || !((_agentPolicy$monitori10 = agentPolicy.monitoring_http) !== null && _agentPolicy$monitori10 !== void 0 && _agentPolicy$monitori10.enabled),
    checked: agentPolicy.monitoring_pprof_enabled,
    onChange: e => {
      updateTouchedFields({
        monitoring_pprof_enabled: true
      });
      updateAgentPolicy({
        monitoring_pprof_enabled: e.target.checked
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(PushedDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsRateLimitLabel",
      defaultMessage: "Diagnostics rate limiting",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsRateLimitDescription",
      defaultMessage: "Rate limit for the request diagnostics action handler. Does not affect diagnostics collected through the CLI. {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.httpMonitoring,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 261,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyForm.diagnosticsRateLimitDescription.learnMoreLinkLabel",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 262,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsRateLimit.intervalFieldLabel",
      defaultMessage: "Interval",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 17
      }
    }),
    isDisabled: disabled,
    error: touchedFields['monitoring_diagnostics.limit.interval'] && validation['monitoring_diagnostics.limit.interval'] ? validation['monitoring_diagnostics.limit.interval'] : null,
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.limit.interval'] && validation['monitoring_diagnostics.limit.interval']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    placeholder: "1m",
    value: (_agentPolicy$monitori11 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori11 === void 0 ? void 0 : (_agentPolicy$monitori12 = _agentPolicy$monitori11.limit) === null || _agentPolicy$monitori12 === void 0 ? void 0 : _agentPolicy$monitori12.interval,
    onChange: e => {
      var _agentPolicy$monitori13;
      updateAgentPolicy({
        monitoring_diagnostics: {
          ...agentPolicy.monitoring_diagnostics,
          limit: {
            ...((_agentPolicy$monitori13 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori13 === void 0 ? void 0 : _agentPolicy$monitori13.limit),
            interval: e.target.value ? e.target.value : undefined
          }
        }
      });
    },
    onBlur: () => updateTouchedFields({
      'monitoring_diagnostics.limit.interval': true
    }),
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.limit.interval'] && validation['monitoring_diagnostics.limit.interval']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsRateLimit.burstFieldLabel",
      defaultMessage: "Burst",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 17
      }
    }),
    isDisabled: disabled,
    error: touchedFields['monitoring_diagnostics.limit.burst'] && validation['monitoring_diagnostics.limit.burst'] ? validation['monitoring_diagnostics.limit.burst'] : null,
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.limit.burst'] && validation['monitoring_diagnostics.limit.burst']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    disabled: disabled,
    placeholder: "1",
    min: 1,
    value: (_agentPolicy$monitori14 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori14 === void 0 ? void 0 : (_agentPolicy$monitori15 = _agentPolicy$monitori14.limit) === null || _agentPolicy$monitori15 === void 0 ? void 0 : _agentPolicy$monitori15.burst,
    onChange: e => {
      var _agentPolicy$monitori16;
      updateAgentPolicy({
        monitoring_diagnostics: {
          ...agentPolicy.monitoring_diagnostics,
          limit: {
            ...((_agentPolicy$monitori16 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori16 === void 0 ? void 0 : _agentPolicy$monitori16.limit),
            burst: e.target.value ? Number(e.target.value) : undefined
          }
        }
      });
    },
    onBlur: () => updateTouchedFields({
      'monitoring_diagnostics.limit.burst': true
    }),
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.limit.burst'] && validation['monitoring_diagnostics.limit.burst']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(PushedDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsFileUploadLabel",
      defaultMessage: "Diagnostics file upload",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsFileUploadDescription",
      defaultMessage: "Retry configuration for the file upload client. Client may retry failed requests with exponential backoff. {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.httpMonitoring,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 383,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyForm.diagnosticsFileUploadDescription.learnMoreLinkLabel",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 384,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 394,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsFileUpload.maxRetriesFieldLabel",
      defaultMessage: "Max retries",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 398,
        columnNumber: 17
      }
    }),
    isDisabled: disabled,
    error: touchedFields['monitoring_diagnostics.uploader.max_retries'] && validation['monitoring_diagnostics.uploader.max_retries'] ? validation['monitoring_diagnostics.uploader.max_retries'] : null,
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.uploader.max_retries'] && validation['monitoring_diagnostics.uploader.max_retries']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    disabled: disabled,
    placeholder: "10",
    min: 1,
    value: (_agentPolicy$monitori17 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori17 === void 0 ? void 0 : (_agentPolicy$monitori18 = _agentPolicy$monitori17.uploader) === null || _agentPolicy$monitori18 === void 0 ? void 0 : _agentPolicy$monitori18.max_retries,
    onChange: e => {
      var _agentPolicy$monitori19;
      updateAgentPolicy({
        monitoring_diagnostics: {
          ...agentPolicy.monitoring_diagnostics,
          uploader: {
            ...((_agentPolicy$monitori19 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori19 === void 0 ? void 0 : _agentPolicy$monitori19.uploader),
            max_retries: e.target.value ? Number(e.target.value) : undefined
          }
        }
      });
    },
    onBlur: () => updateTouchedFields({
      'monitoring_diagnostics.uploader.max_retries': true
    }),
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.uploader.max_retries'] && validation['monitoring_diagnostics.uploader.max_retries']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsFileUpload.initialDurationFieldLabel",
      defaultMessage: "Initial duration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 444,
        columnNumber: 17
      }
    }),
    isDisabled: disabled,
    error: touchedFields['monitoring_diagnostics.uploader.init_dur'] && validation['monitoring_diagnostics.uploader.init_dur'] ? validation['monitoring_diagnostics.uploader.init_dur'] : null,
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.uploader.init_dur'] && validation['monitoring_diagnostics.uploader.init_dur']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    placeholder: "1s",
    value: (_agentPolicy$monitori20 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori20 === void 0 ? void 0 : (_agentPolicy$monitori21 = _agentPolicy$monitori20.uploader) === null || _agentPolicy$monitori21 === void 0 ? void 0 : _agentPolicy$monitori21.init_dur,
    onChange: e => {
      var _agentPolicy$monitori22;
      updateAgentPolicy({
        monitoring_diagnostics: {
          ...agentPolicy.monitoring_diagnostics,
          uploader: {
            ...((_agentPolicy$monitori22 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori22 === void 0 ? void 0 : _agentPolicy$monitori22.uploader),
            init_dur: e.target.value ? e.target.value : undefined
          }
        }
      });
    },
    onBlur: () => updateTouchedFields({
      'monitoring_diagnostics.uploader.init_dur': true
    }),
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.uploader.init_dur'] && validation['monitoring_diagnostics.uploader.init_dur']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.diagnosticsFileUpload.maxDurationFieldLabel",
      defaultMessage: "Backoff duration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 489,
        columnNumber: 17
      }
    }),
    isDisabled: disabled,
    error: touchedFields['monitoring_diagnostics.uploader.max_dur'] && validation['monitoring_diagnostics.uploader.max_dur'] ? validation['monitoring_diagnostics.uploader.max_dur'] : null,
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.uploader.max_dur'] && validation['monitoring_diagnostics.uploader.max_dur']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 487,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    placeholder: "1m",
    value: (_agentPolicy$monitori23 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori23 === void 0 ? void 0 : (_agentPolicy$monitori24 = _agentPolicy$monitori23.uploader) === null || _agentPolicy$monitori24 === void 0 ? void 0 : _agentPolicy$monitori24.max_dur,
    onChange: e => {
      var _agentPolicy$monitori25;
      updateAgentPolicy({
        monitoring_diagnostics: {
          ...agentPolicy.monitoring_diagnostics,
          uploader: {
            ...((_agentPolicy$monitori25 = agentPolicy.monitoring_diagnostics) === null || _agentPolicy$monitori25 === void 0 ? void 0 : _agentPolicy$monitori25.uploader),
            max_dur: e.target.value ? e.target.value : undefined
          }
        }
      });
    },
    onBlur: () => updateTouchedFields({
      'monitoring_diagnostics.uploader.max_dur': true
    }),
    isInvalid: Boolean(touchedFields['monitoring_diagnostics.uploader.max_dur'] && validation['monitoring_diagnostics.uploader.max_dur']),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 506,
      columnNumber: 15
    }
  }))))));
};
exports.AgentPolicyAdvancedMonitoringOptions = AgentPolicyAdvancedMonitoringOptions;