"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_dismissable_tour = require("../../../../hooks/use_dismissable_tour");
var _hooks = require("../../hooks");
var _layouts = require("../../../../layouts");
var _use_tour_manager = require("../../../../hooks/use_tour_manager");
var _auto_upgrade_agents_tour = require("../../sections/agent_policy/components/auto_upgrade_agents_tour");
var _use_can_enable_auto_upgrades = require("../../../../hooks/use_can_enable_auto_upgrades");
var _default_page_title = require("./default_page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/layouts/default/default.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DefaultLayout = ({
  section,
  children,
  rightColumn
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    agents
  } = (0, _hooks.useConfig)();
  const authz = (0, _hooks.useAuthz)();
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const granularPrivilegesCallout = (0, _use_dismissable_tour.useDismissableTour)('GRANULAR_PRIVILEGES');
  const canEnableAutomaticAgentUpgrades = (0, _use_can_enable_auto_upgrades.useCanEnableAutomaticAgentUpgrades)();
  const tabs = [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.agentsLinkText",
      defaultMessage: "Agents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }),
    isSelected: section === 'agents',
    href: getHref('agent_list'),
    disabled: !(agents !== null && agents !== void 0 && agents.enabled),
    'data-test-subj': 'fleet-agents-tab',
    isHidden: !authz.fleet.readAgents
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.policiesLinkText",
      defaultMessage: "Agent policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }),
    isHidden: !authz.fleet.readAgentPolicies,
    isSelected: section === 'agent_policies',
    href: getHref('policies_list'),
    'data-test-subj': 'fleet-agent-policies-tab',
    id: 'fleet-agent-policies-tab'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.enrollmentTokensText",
      defaultMessage: "Enrollment tokens",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }),
    isHidden: !authz.fleet.allAgents,
    isSelected: section === 'enrollment_tokens',
    href: getHref('enrollment_tokens'),
    'data-test-subj': 'fleet-enrollment-tokens-tab'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.uninstallTokensText",
      defaultMessage: "Uninstall tokens",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }),
    isSelected: section === 'uninstall_tokens',
    href: getHref('uninstall_tokens'),
    'data-test-subj': 'fleet-uninstall-tokens-tab',
    isHidden: !authz.fleet.allAgents
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.dataStreamsLinkText",
      defaultMessage: "Data streams",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }),
    isSelected: section === 'data_streams',
    href: getHref('data_streams'),
    'data-test-subj': 'fleet-datastreams-tab'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.appNavigation.settingsLinkText",
      defaultMessage: "Settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }),
    isHidden: !authz.fleet.readSettings,
    isSelected: section === 'settings',
    href: getHref('settings'),
    'data-test-subj': 'fleet-settings-tab'
  }]
  // Removed hidden tabs
  .filter(({
    isHidden
  }) => !isHidden).map(({
    isHidden,
    ...tab
  }) => tab);
  return /*#__PURE__*/_react.default.createElement(_use_tour_manager.TourManagerProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, !authz.fleet.all || granularPrivilegesCallout.isHidden ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "cheer",
    onDismiss: granularPrivilegesCallout.dismiss,
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.granularPrivileges.callOutContent",
      defaultMessage: "We've added new privileges that let you define more granularly who can view or edit Fleet agents, policies, and settings. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.roleAndPrivileges,
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.granularPrivileges.learnMoreLinkText",
          defaultMessage: "Learn more.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 25
          }
        })))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: /*#__PURE__*/_react.default.createElement(_default_page_title.DefaultPageTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 37
      }
    }),
    rightColumn: rightColumn,
    tabs: tabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, children), canEnableAutomaticAgentUpgrades ? /*#__PURE__*/_react.default.createElement(_auto_upgrade_agents_tour.AutoUpgradeAgentsTour, {
    anchor: "#fleet-agent-policies-tab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }) : null);
};
exports.DefaultLayout = DefaultLayout;