"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._sortYamlKeys = _sortYamlKeys;
exports.fullAgentPolicyToYaml = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_KEYS_ORDER = ['id', 'name', 'revision', 'dataset', 'type', 'outputs', 'fleet', 'output_permissions', 'agent', 'inputs', 'enabled', 'use_output', 'meta', 'input', 'download', 'signed'];
const fullAgentPolicyToYaml = (policy, toYaml, apiKey) => {
  var _policy$secret_refere;
  const yaml = toYaml(policy, {
    skipInvalid: true,
    sortKeys: _sortYamlKeys
  });
  const formattedYml = apiKey ? replaceApiKey(yaml, apiKey) : yaml;
  if (!(policy !== null && policy !== void 0 && (_policy$secret_refere = policy.secret_references) !== null && _policy$secret_refere !== void 0 && _policy$secret_refere.length)) return formattedYml;
  return _formatSecrets(policy.secret_references, formattedYml);
};
exports.fullAgentPolicyToYaml = fullAgentPolicyToYaml;
function _sortYamlKeys(keyA, keyB) {
  const indexA = POLICY_KEYS_ORDER.indexOf(keyA);
  const indexB = POLICY_KEYS_ORDER.indexOf(keyB);
  if (indexA >= 0 && indexB < 0) {
    return -1;
  }
  if (indexA < 0 && indexB >= 0) {
    return 1;
  }
  return indexA - indexB;
}
function _formatSecrets(secretRefs, ymlText) {
  let formattedText = ymlText;
  const secretIds = secretRefs.map(ref => ref.id);
  secretIds.forEach((secretId, idx) => {
    const regex = new RegExp(`\\$co\\.elastic\\.secret\\{${secretId}\\}`, 'g');
    formattedText = formattedText.replace(regex, `\${SECRET_${idx}}`);
  });
  return formattedText;
}
function replaceApiKey(ymlText, apiKey) {
  const regex = new RegExp(/\$\{API_KEY}/, 'g');
  return ymlText.replace(regex, `'${apiKey}'`);
}