"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedFilters = SelectedFilters;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filter_label = require("../../components/filter_label");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _use_series_filters = require("../../hooks/use_series_filters");
var _use_series_storage = require("../../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/selected_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SelectedFilters({
  seriesId,
  series,
  seriesConfig
}) {
  var _series$filters, _series$filters2;
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    labels
  } = seriesConfig;
  const filters = (_series$filters = series.filters) !== null && _series$filters !== void 0 ? _series$filters : [];
  const {
    removeFilter,
    replaceFilter
  } = (0, _use_series_filters.useSeriesFilters)({
    seriesId,
    series
  });
  const {
    dataView
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  if (filters.length === 0 || !dataView) {
    return null;
  }
  const btnProps = {
    seriesId,
    series,
    dataView
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, filters.map(({
    field,
    values = [],
    notValues = [],
    wildcards = [],
    notWildcards = []
  }) => {
    var _labels$field, _labels$field2, _labels$field3, _labels$field4;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: field,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }, values.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        maxWidth: 300
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: (_labels$field = labels[field]) !== null && _labels$field !== void 0 ? _labels$field : field,
      value: values !== null && values !== void 0 ? values : [],
      removeFilter: () => {
        replaceFilter({
          field,
          values: [],
          notValues,
          wildcards,
          notWildcards
        });
      },
      negate: false
    }, btnProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 19
      }
    }))), notValues.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: field,
      grow: false,
      style: {
        maxWidth: 300
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: (_labels$field2 = labels[field]) !== null && _labels$field2 !== void 0 ? _labels$field2 : field,
      value: notValues !== null && notValues !== void 0 ? notValues : [],
      negate: true,
      removeFilter: () => {
        replaceFilter({
          field,
          notValues: [],
          values,
          wildcards,
          notWildcards
        });
      }
    }, btnProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 19
      }
    }))), wildcards.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: field,
      grow: false,
      style: {
        maxWidth: 300
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: _i18n.i18n.translate('xpack.exploratoryView.filters.label.wildcard', {
        defaultMessage: '{label} wildcard',
        values: {
          label: (_labels$field3 = labels[field]) !== null && _labels$field3 !== void 0 ? _labels$field3 : field
        }
      }),
      value: wildcards !== null && wildcards !== void 0 ? wildcards : [],
      negate: false,
      removeFilter: () => {
        wildcards === null || wildcards === void 0 ? void 0 : wildcards.forEach(val => {
          removeFilter({
            field,
            value: val,
            negate: false,
            isWildcard: true
          });
        });
      }
    }, btnProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 19
      }
    }))), notWildcards.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: field,
      grow: false,
      style: {
        maxWidth: 300
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: _i18n.i18n.translate('xpack.exploratoryView.filters.label.wildcard', {
        defaultMessage: '{label} wildcard',
        values: {
          label: (_labels$field4 = labels[field]) !== null && _labels$field4 !== void 0 ? _labels$field4 : field
        }
      }),
      value: notWildcards !== null && notWildcards !== void 0 ? notWildcards : [],
      negate: false,
      removeFilter: () => {
        notWildcards === null || notWildcards === void 0 ? void 0 : notWildcards.forEach(val => {
          removeFilter({
            field,
            value: val,
            negate: true,
            isWildcard: true
          });
        });
      }
    }, btnProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 19
      }
    }))));
  }), ((_series$filters2 = series.filters) !== null && _series$filters2 !== void 0 ? _series$filters2 : []).length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11ySelectedFiltersClearFiltersButton",
    flush: "left",
    iconType: "cross",
    onClick: () => {
      setSeries(seriesId, {
        ...series,
        filters: undefined
      });
    },
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.clearFilter', {
    defaultMessage: 'Clear filters'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }));
}