"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsKqlFreeText = getIsKqlFreeText;
exports.getIsKqlFreeTextExpression = getIsKqlFreeTextExpression;
var _ = require("../../..");
var _node_types = require("../node_types");
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Returns true whether the given expression contains at least one free text expression (e.g. `foo: "bar" AND my_free_text_query`)
 */
function getIsKqlFreeTextExpression(expression) {
  const node = (0, _.fromKueryExpression)(expression);
  return getIsKqlFreeText(node);
}
function getIsKqlFreeText(node) {
  if (_node_types.nodeTypes.function.isNode(node)) {
    if (_functions.functions.and.isNode(node) || _functions.functions.or.isNode(node)) {
      return node.arguments.reduce((result, child) => {
        return result || getIsKqlFreeText(child);
      }, false);
    } else if (_functions.functions.not.isNode(node) || _functions.functions.exists.isNode(node) || _functions.functions.is.isNode(node) || _functions.functions.nested.isNode(node) || _functions.functions.range.isNode(node)) {
      // For each of these field types, we only need to look at the first argument to determine the fields
      const [fieldNode] = node.arguments;
      return getIsKqlFreeText(fieldNode);
    } else {
      throw new Error(`KQL function ${node.function} not supported in isKqlFreeText`);
    }
  } else if (_node_types.nodeTypes.literal.isNode(node)) {
    return node.value === null;
  } else if (_node_types.nodeTypes.wildcard.isNode(node)) {
    return false;
  } else {
    throw new Error(`KQL node type ${node.type} not supported in isKqlFreeText`);
  }
}