"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startTransforms = startTransforms;
var _retry = require("./helpers/retry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function startTransforms(esClient, definition, logger) {
  try {
    var _definition$installed;
    await Promise.all(((_definition$installed = definition.installedComponents) !== null && _definition$installed !== void 0 ? _definition$installed : []).filter(({
      type
    }) => type === 'transform').map(({
      id
    }) => (0, _retry.retryTransientEsErrors)(() => esClient.transform.startTransform({
      transform_id: id
    }, {
      ignore: [409]
    }), {
      logger
    })));
  } catch (err) {
    logger.error(`Cannot start entity transforms [${definition.id}]: ${err}`);
    throw err;
  }
}