"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorFilteringLogic = void 0;
var _kea = require("kea");
var _lodash = require("lodash");
var _searchConnectors = require("@kbn/search-connectors");
var _api = require("../../../../../../../common/types/api");
var _flash_messages = require("../../../../../shared/flash_messages");
var _update_connector_filtering_api_logic = require("../../../../api/connector/update_connector_filtering_api_logic");
var _update_connector_filtering_draft_api_logic = require("../../../../api/connector/update_connector_filtering_draft_api_logic");
var _fetch_index_api_logic = require("../../../../api/index/fetch_index_api_logic");
var _indices = require("../../../../utils/indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDefaultRule(order) {
  const now = new Date().toISOString();
  return {
    created_at: now,
    field: '_',
    id: 'DEFAULT',
    order,
    policy: 'include',
    rule: 'regex',
    updated_at: now,
    value: '.*'
  };
}
const ConnectorFilteringLogic = exports.ConnectorFilteringLogic = (0, _kea.kea)({
  actions: {
    addFilteringRule: filteringRule => filteringRule,
    applyDraft: true,
    deleteFilteringRule: filteringRule => filteringRule,
    reorderFilteringRules: filteringRules => filteringRules,
    revertLocalAdvancedFiltering: true,
    revertLocalFilteringRules: true,
    saveDraftFilteringRules: true,
    setFilteringConfig: filteringConfig => filteringConfig,
    setIsEditing: isEditing => ({
      isEditing
    }),
    setLocalAdvancedSnippet: advancedSnippet => ({
      advancedSnippet
    }),
    setLocalFilteringRules: filteringRules => filteringRules,
    updateFilteringRule: filteringRule => filteringRule
  },
  connect: {
    actions: [_update_connector_filtering_api_logic.ConnectorFilteringApiLogic, ['apiSuccess', 'makeRequest'], _update_connector_filtering_draft_api_logic.ConnectorFilteringDraftApiLogic, ['apiError as draftApiError', 'apiSuccess as draftApiSuccess', 'makeRequest as draftMakeRequest'], _fetch_index_api_logic.FetchIndexApiLogic, ['apiSuccess as fetchIndexApiSuccess']],
    values: [_update_connector_filtering_api_logic.ConnectorFilteringApiLogic, ['status'], _fetch_index_api_logic.FetchIndexApiLogic, ['data as index']]
  },
  events: ({
    actions,
    values
  }) => ({
    afterMount: () => actions.setFilteringConfig((0, _indices.isConnectorIndex)(values.index) ? values.index.connector.filtering[0] : null)
  }),
  listeners: ({
    actions,
    values
  }) => ({
    applyDraft: () => {
      if ((0, _indices.isConnectorIndex)(values.index)) {
        actions.makeRequest({
          connectorId: values.index.connector.id
        });
      }
    },
    fetchIndexApiSuccess: index => {
      if (!values.isEditing && (0, _indices.isConnectorIndex)(index) && !(0, _lodash.isEqual)(values.filteringConfig, index.connector.filtering[0])) {
        actions.setFilteringConfig(index.connector.filtering[0]);
      }
    },
    makeRequest: () => (0, _flash_messages.clearFlashMessages)(),
    saveDraftFilteringRules: () => {
      if ((0, _indices.isConnectorIndex)(values.index)) {
        var _values$localAdvanced, _values$localFilterin;
        actions.draftMakeRequest({
          advancedSnippet: (_values$localAdvanced = values.localAdvancedSnippet) !== null && _values$localAdvanced !== void 0 ? _values$localAdvanced : '',
          connectorId: values.index.connector.id,
          filteringRules: (_values$localFilterin = values.localFilteringRules) !== null && _values$localFilterin !== void 0 ? _values$localFilterin : []
        });
      }
    },
    setIsEditing: isEditing => {
      if (isEditing && values.filteringConfig) {
        var _values$filteringConf, _values$filteringConf2;
        actions.setLocalFilteringRules(values.hasDraft ? values.filteringConfig.draft.rules : values.filteringConfig.active.rules);
        actions.setLocalAdvancedSnippet(values.hasDraft ? JSON.stringify((_values$filteringConf = values.filteringConfig.draft.advanced_snippet.value) !== null && _values$filteringConf !== void 0 ? _values$filteringConf : {}, undefined, 2) : JSON.stringify((_values$filteringConf2 = values.filteringConfig.active.advanced_snippet.value) !== null && _values$filteringConf2 !== void 0 ? _values$filteringConf2 : {}, undefined, 2));
      }
    }
  }),
  path: ['enterprise_search', 'content', 'connector_filtering'],
  reducers: () => ({
    filteringConfig: [null, {
      apiSuccess: (filteringConfig, filteringRules) => filteringConfig ? {
        ...filteringConfig,
        active: filteringRules
      } : null,
      draftApiSuccess: (filteringConfig, filteringRules) => filteringConfig ? {
        ...filteringConfig,
        draft: filteringRules
      } : null,
      setFilteringConfig: (_, filteringConfig) => filteringConfig
    }],
    isEditing: [false, {
      draftApiError: () => false,
      draftApiSuccess: () => false,
      setIsEditing: (_, {
        isEditing
      }) => isEditing
    }],
    localAdvancedSnippet: ['', {
      setLocalAdvancedSnippet: (_, {
        advancedSnippet
      }) => advancedSnippet
    }],
    localFilteringRules: [[], {
      addFilteringRule: (filteringRules, filteringRule) => {
        const newFilteringRules = filteringRules.length ? [...filteringRules.slice(0, filteringRules.length - 1), filteringRule, filteringRules[filteringRules.length - 1]] : [filteringRule, createDefaultRule(1)];
        return newFilteringRules.map((rule, index) => ({
          ...rule,
          order: index
        }));
      },
      deleteFilteringRule: (filteringRules, filteringRule) => filteringRules.filter(rule => rule.id !== filteringRule.id),
      reorderFilteringRules: (filteringRules, newFilteringRules) => {
        const lastItem = filteringRules.length ? filteringRules[filteringRules.length - 1] : createDefaultRule(0);
        return [...newFilteringRules, lastItem].map((rule, index) => ({
          ...rule,
          order: index
        }));
      },
      setLocalFilteringRules: (_, filteringRules) => filteringRules,
      updateFilteringRule: (filteringRules, filteringRule) => filteringRules.map(rule => rule.id === filteringRule.id ? filteringRule : rule)
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    advancedSnippet: [() => [selectors.filteringConfig], filteringConfig => filteringConfig !== null && filteringConfig !== void 0 && filteringConfig.active.advanced_snippet.value ? JSON.stringify(filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.active.advanced_snippet.value, undefined, 2) : ''],
    draftErrors: [() => [selectors.filteringConfig], filteringConfig => {
      var _filteringConfig$draf;
      return (_filteringConfig$draf = filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.draft.validation.errors) !== null && _filteringConfig$draf !== void 0 ? _filteringConfig$draf : [];
    }],
    draftState: [() => [selectors.filteringConfig], filteringConfig => {
      var _filteringConfig$draf2;
      return (_filteringConfig$draf2 = filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.draft.validation.state) !== null && _filteringConfig$draf2 !== void 0 ? _filteringConfig$draf2 : _searchConnectors.FilteringValidationState.VALID;
    }],
    editableFilteringRules: [() => [selectors.localFilteringRules], filteringRules => {
      return filteringRules !== null && filteringRules !== void 0 && filteringRules.length ? filteringRules.slice(0, filteringRules.length - 1) : [];
    }],
    filteringRules: [() => [selectors.filteringConfig], filteringConfig => {
      var _filteringConfig$acti;
      return (_filteringConfig$acti = filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.active.rules) !== null && _filteringConfig$acti !== void 0 ? _filteringConfig$acti : [];
    }],
    hasDraft: [() => [selectors.filteringConfig], filteringConfig => !(0, _lodash.isEqual)(filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.active.advanced_snippet.value, filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.draft.advanced_snippet.value) || !(0, _lodash.isEqual)(filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.draft.rules, filteringConfig === null || filteringConfig === void 0 ? void 0 : filteringConfig.active.rules)],
    hasJsonValidationError: [() => [selectors.localAdvancedSnippet], advancedSnippet => {
      if (!advancedSnippet) return false;
      try {
        JSON.parse(advancedSnippet);
        return false;
      } catch {
        return true;
      }
    }],
    isLoading: [() => [selectors.status], status => status === _api.Status.LOADING]
  })
});