"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverEnhancedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _public3 = require("@kbn/embeddable-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DiscoverEnhancedPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.context = context;
    this.config = context.config.get();
  }
  setup(core, {
    uiActions,
    share
  }) {
    const start = (0, _public2.createStartServicesGetter)(core.getStartServices);
    const isSharePluginInstalled = !!share;
    if (isSharePluginInstalled) {
      const params = {
        start
      };
      if (this.config.actions.exploreDataInContextMenu.enabled) {
        uiActions.addTriggerActionAsync(_public3.CONTEXT_MENU_TRIGGER, 'ACTION_EXPLORE_DATA', async () => {
          const {
            ExploreDataContextMenuAction
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
          const exploreDataAction = new ExploreDataContextMenuAction(params);
          return exploreDataAction;
        });
      }
      if (this.config.actions.exploreDataInChart.enabled) {
        uiActions.addTriggerActionAsync(_public.APPLY_FILTER_TRIGGER, 'ACTION_EXPLORE_DATA_CHART', async () => {
          const {
            ExploreDataChartAction
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
          const exploreDataChartAction = new ExploreDataChartAction(params);
          return exploreDataChartAction;
        });
      }
    }
  }
  start(core, plugins) {}
  stop() {}
}
exports.DiscoverEnhancedPlugin = DiscoverEnhancedPlugin;