"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleError = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleError = ({
  onError,
  request,
  error,
  title
}) => {
  // Log error and request for debugging purposes
  // eslint-disable-next-line no-console
  console.error(error, request);
  if (onError) {
    error.handled = true;
    error.message = JSON.stringify(request);
    onError(error, title !== null && title !== void 0 ? title : _i18n.i18n.translate('xpack.dataVisualizer.esql.errorMessage', {
      defaultMessage: 'Error excecuting ES|QL request:'
    }));
  }
};
exports.handleError = handleError;