"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _json_editor = require("./json_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/pipeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IngestPipeline = ({
  pipeline,
  setPipeline,
  showTitle = true,
  readonly = false,
  showBorder = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [localPipeline, setLocalPipeline] = (0, _react.useState)(JSON.stringify(pipeline, null, 2));
  (0, _react.useEffect)(() => {
    setLocalPipeline(JSON.stringify(pipeline, null, 2));
  }, [pipeline]);
  (0, _useDebounce.default)(() => {
    if (setPipeline && pipeline !== undefined) {
      const pOriginal = JSON.stringify(pipeline);
      const pLocal = JSON.stringify(JSON.parse(localPipeline));
      if (pOriginal !== pLocal) {
        setPipeline(localPipeline);
      }
    }
  }, 500, [localPipeline]);
  const css = (0, _react.useMemo)(() => readonly ? {} : {
    backgroundColor: euiTheme.colors.backgroundBaseSubdued
  }, [euiTheme, readonly]);
  const editor = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: showBorder,
    paddingSize: "none",
    "data-test-subj": "dvMappingsEditor",
    css: css,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: _json_editor.EDITOR_MODE.JSON,
    readOnly: readonly,
    value: localPipeline,
    onChange: value => {
      setLocalPipeline(value);
    },
    transparentBackground: readonly === false,
    width: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
  return showTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.ingestPipelineLabel",
      defaultMessage: "Ingest pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, editor) : editor;
};
exports.IngestPipeline = IngestPipeline;