"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSyncingExpandedPanelState = exports.loadAndRemoveDashboardState = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _rxjs = require("rxjs");
var _urls = require("../../utils/urls");
var _extract_dashboard_state = require("./bwc/extract_dashboard_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Loads any dashboard state from the URL, and removes the state from the URL.
 */
const loadAndRemoveDashboardState = kbnUrlStateStorage => {
  const rawAppStateInUrl = kbnUrlStateStorage.get(_urls.DASHBOARD_STATE_STORAGE_KEY);
  if (!rawAppStateInUrl) return {};

  // clear application state from URL
  const nextUrl = (0, _common.replaceUrlHashQuery)(window.location.href, hashQuery => {
    delete hashQuery[_urls.DASHBOARD_STATE_STORAGE_KEY];
    return hashQuery;
  });
  kbnUrlStateStorage.kbnUrlControls.update(nextUrl, true);
  return (0, _extract_dashboard_state.extractDashboardState)(rawAppStateInUrl);
};
exports.loadAndRemoveDashboardState = loadAndRemoveDashboardState;
const startSyncingExpandedPanelState = ({
  dashboardApi,
  history
}) => {
  const expandedPanelSubscription = dashboardApi === null || dashboardApi === void 0 ? void 0 : dashboardApi.expandedPanelId$
  // skip the first value because we don't want to trigger a history.replace on initial load
  .pipe((0, _rxjs.skip)(1)).subscribe(expandedPanelId => {
    history.replace({
      ...history.location,
      pathname: `${(0, _urls.createDashboardEditUrl)(dashboardApi.savedObjectId$.value)}${Boolean(expandedPanelId) ? `/${expandedPanelId}` : ''}`
    });
  });
  const stopWatchingExpandedPanel = () => expandedPanelSubscription.unsubscribe();
  return {
    stopWatchingExpandedPanel
  };
};
exports.startSyncingExpandedPanelState = startSyncingExpandedPanelState;