"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMenu = void 0;
exports.showAddMenu = showAddMenu;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _controlsConstants = require("@kbn/controls-constants");
var _esqlTypes = require("@kbn/esql-types");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationUtil = require("@kbn/presentation-util");
var _execute_add_lens_panel_action = require("../../../dashboard_actions/execute_add_lens_panel_action");
var _add_panel_from_library = require("../../../dashboard_renderer/add_panel_from_library");
var _kibana_services = require("../../../services/kibana_services");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/top_nav/add_menu/show_add_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const container = document.createElement('div');
let isOpen = false;
function cleanup() {
  if (!isOpen) {
    return;
  }
  _reactDom.default.unmountComponentAtNode(container);
  document.body.removeChild(container);
  isOpen = false;
}
const AddMenu = ({
  dashboardApi,
  anchorElement,
  coreServices
}) => {
  const [hasTimeSliderControl, setHasTimeSliderControl] = (0, _react.useState)(false);
  const controlGroupApi = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.controlGroupApi$);
  (0, _react.useEffect)(() => {
    if (!controlGroupApi) {
      return;
    }
    const subscription = controlGroupApi.children$.subscribe(children => {
      const nextHasTimeSliderControl = Object.values(children).some(controlApi => {
        return (0, _presentationPublishing.apiHasType)(controlApi) && controlApi.type === _controlsConstants.TIME_SLIDER_CONTROL;
      });
      setHasTimeSliderControl(nextHasTimeSliderControl);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroupApi]);
  const onSave = () => {
    dashboardApi.scrollToTop();
  };
  const closePopover = (0, _react.useCallback)(() => {
    cleanup();
    anchorElement.focus();
  }, [anchorElement]);
  const openAddPanelFlyout = (0, _react.useCallback)(() => {
    (0, _presentationUtil.openLazyFlyout)({
      core: coreServices,
      parentApi: dashboardApi,
      loadContent: async ({
        closeFlyout,
        ariaLabelledBy
      }) => {
        const {
          AddPanelFlyout
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../add_panel_button/components/add_panel_flyout')));
        return /*#__PURE__*/_react.default.createElement(AddPanelFlyout, {
          dashboardApi: dashboardApi,
          closeFlyout: closeFlyout,
          ariaLabelledBy: ariaLabelledBy,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 11
          }
        });
      },
      flyoutProps: {
        'data-test-subj': 'dashboardPanelSelectionFlyout',
        triggerId: 'dashboardAddTopNavButton'
      }
    });
  }, [coreServices, dashboardApi]);
  const panels = [{
    id: 0,
    initialFocusedItemIndex: 0,
    items: [{
      name: (0, _dashboard_app_strings.getCreateVisualizationButtonTitle)(),
      icon: 'lensApp',
      'data-test-subj': 'dashboardCreateNewVisButton',
      onClick: async () => {
        await (0, _execute_add_lens_panel_action.executeAddLensPanelAction)(dashboardApi);
        closePopover();
      }
    }, {
      name: _i18n.i18n.translate('dashboard.solutionToolbar.editorMenuButtonLabel', {
        defaultMessage: 'New panel'
      }),
      icon: 'plusInCircle',
      'data-test-subj': 'dashboardOpenAddPanelFlyoutButton',
      onClick: () => {
        openAddPanelFlyout();
        closePopover();
      }
    }, {
      name: _i18n.i18n.translate('dashboard.solutionToolbar.addSectionButtonLabel', {
        defaultMessage: 'Collapsible section'
      }),
      icon: 'section',
      'data-test-subj': 'dashboardAddCollapsibleSectionButton',
      onClick: () => {
        dashboardApi.addNewSection();
        closePopover();
      }
    }, {
      name: (0, _dashboard_app_strings.getControlButtonTitle)(),
      icon: 'controlsHorizontal',
      'data-test-subj': 'dashboard-controls-menu-button',
      panel: 1
    }, {
      name: _i18n.i18n.translate('dashboard.buttonToolbar.buttons.addFromLibrary.libraryButtonLabel', {
        defaultMessage: 'From library'
      }),
      'data-test-subj': 'dashboardAddFromLibraryButton',
      icon: 'folderOpen',
      onClick: () => {
        (0, _add_panel_from_library.addFromLibrary)(dashboardApi);
        closePopover();
      }
    }]
  }, {
    id: 1,
    title: (0, _dashboard_app_strings.getControlButtonTitle)(),
    initialFocusedItemIndex: 0,
    items: [{
      name: (0, _dashboard_app_strings.getAddControlButtonTitle)(),
      icon: 'empty',
      disabled: !controlGroupApi,
      'data-test-subj': 'controls-create-button',
      onClick: () => {
        controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.openAddDataControlFlyout({
          onSave
        });
        closePopover();
      }
    }, {
      name: (0, _dashboard_app_strings.getAddESQLControlButtonTitle)(),
      icon: 'empty',
      disabled: !controlGroupApi,
      'data-test-subj': 'esql-control-create-button',
      onClick: async () => {
        try {
          const variablesInParent = (0, _esqlTypes.apiPublishesESQLVariables)(dashboardApi) ? dashboardApi.esqlVariables$.value : [];
          await _kibana_services.uiActionsService.getTrigger('ESQL_CONTROL_TRIGGER').exec({
            queryString: '',
            variableType: _esqlTypes.ESQLVariableType.VALUES,
            controlType: _esqlTypes.EsqlControlType.VALUES_FROM_QUERY,
            esqlVariables: variablesInParent,
            parentApi: dashboardApi,
            onSaveControl: controlState => {
              controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.addNewPanel({
                panelType: 'esqlControl',
                serializedState: {
                  rawState: {
                    ...controlState
                  }
                }
              });
              dashboardApi.scrollToTop();
              closePopover();
            },
            onCancelControl: closePopover
          });
        } catch (e) {
          // eslint-disable-next-line no-console
          console.error('Error getting ESQL control trigger', e);
        }
        closePopover();
      }
    }, {
      name: (0, _dashboard_app_strings.getAddTimeSliderControlButtonTitle)(),
      icon: 'empty',
      'data-test-subj': 'controls-create-timeslider-button',
      disabled: !controlGroupApi || hasTimeSliderControl,
      onClick: async () => {
        controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.addNewPanel({
          panelType: _controlsConstants.TIME_SLIDER_CONTROL,
          serializedState: {
            rawState: {
              grow: true,
              width: 'large',
              id: (0, _uuid.v4)()
            }
          }
        });
        dashboardApi.scrollToTop();
        closePopover();
      }
    }, {
      isSeparator: true,
      key: 'sep'
    }, {
      name: (0, _dashboard_app_strings.getEditControlGroupButtonTitle)(),
      icon: 'empty',
      'data-test-subj': 'controls-settings-button',
      disabled: !controlGroupApi,
      onClick: async () => {
        controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.onEdit();
        closePopover();
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: isOpen,
    closePopover: closePopover,
    button: anchorElement,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }));
};
exports.AddMenu = AddMenu;
function showAddMenu({
  dashboardApi,
  anchorElement,
  coreServices
}) {
  if (isOpen) {
    cleanup();
    return;
  }
  isOpen = true;
  document.body.appendChild(container);
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: coreServices,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AddMenu, {
    dashboardApi: dashboardApi,
    anchorElement: anchorElement,
    coreServices: coreServices,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  })), container);
}