"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataControlEditorStrings = void 0;
var _i18n = require("@kbn/i18n");
var _controlsConstants = require("@kbn/controls-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DataControlEditorStrings = exports.DataControlEditorStrings = {
  manageControl: {
    getFlyoutCreateTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.createFlyoutTitle', {
      defaultMessage: 'Create control'
    }),
    getFlyoutEditTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.editFlyoutTitle', {
      defaultMessage: 'Edit control'
    }),
    dataSource: {
      getSelectDataViewMessage: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.selectDataViewMessage', {
        defaultMessage: 'Please select a data view'
      }),
      getDataViewTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.dataViewTitle', {
        defaultMessage: 'Data view'
      }),
      getDataViewListErrorTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.dataViewListErrorTitle', {
        defaultMessage: 'Error loading data views'
      }),
      getFieldTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.fieldTitle', {
        defaultMessage: 'Field'
      }),
      getFieldListErrorTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.fieldListErrorTitle', {
        defaultMessage: 'Error loading the field list'
      }),
      getControlTypeTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.controlTypesTitle', {
        defaultMessage: 'Control type'
      }),
      getControlTypeErrorMessage: ({
        fieldSelected,
        controlType
      }) => {
        if (!fieldSelected) {
          return _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.controlTypErrorMessage.noField', {
            defaultMessage: 'Select a field first.'
          });
        }
        switch (controlType) {
          /**
           * Note that options list controls are currently compatible with every field type; so, there is no
           * need to have a special error message for these.
           */
          case _controlsConstants.RANGE_SLIDER_CONTROL:
            {
              return _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.controlTypeErrorMessage.rangeSlider', {
                defaultMessage: 'Range sliders are only compatible with number fields.'
              });
            }
          default:
            {
              /** This shouldn't ever happen - but, adding just in case as a fallback. */
              return _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.controlTypeErrorMessage.default', {
                defaultMessage: 'Select a compatible control type.'
              });
            }
        }
      }
    },
    displaySettings: {
      getTitleInputTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.titleInputTitle', {
        defaultMessage: 'Label'
      }),
      getWidthInputTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.widthInputTitle', {
        defaultMessage: 'Minimum width'
      }),
      getGrowSwitchTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.growSwitchTitle', {
        defaultMessage: 'Expand width to fit available space'
      })
    },
    controlTypeSettings: {
      getFormGroupTitle: type => _i18n.i18n.translate('controls.controlGroup.manageControl.controlTypeSettings.formGroupTitle', {
        defaultMessage: '{controlType} settings',
        values: {
          controlType: type
        }
      }),
      getFormGroupDescription: type => _i18n.i18n.translate('controls.controlGroup.manageControl.controlTypeSettings.formGroupDescription', {
        defaultMessage: 'Custom settings for your {controlType} control.',
        values: {
          controlType: type.toLocaleLowerCase()
        }
      })
    },
    getSaveChangesTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.saveChangesTitle', {
      defaultMessage: 'Save'
    }),
    getCancelTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.cancelTitle', {
      defaultMessage: 'Cancel'
    }),
    getDeleteButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.management.delete', {
      defaultMessage: 'Delete control'
    })
  },
  management: {
    controlWidth: {
      getWidthSwitchLegend: () => _i18n.i18n.translate('controls.controlGroup.management.layout.controlWidthLegend', {
        defaultMessage: 'Change control size'
      })
    }
  }
};