"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generatedIndexName = void 0;
var _uuid = require("uuid");
var _searchConnectors = require("@kbn/search-connectors");
var _error_codes = require("../../../common/types/error_codes");
var _exists_index = require("./exists_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generatedIndexName = async (client, indexNamePrefix) => {
  const prefix = (0, _searchConnectors.toAlphanumeric)(indexNamePrefix);
  if (!prefix || prefix.length === 0) {
    throw new Error('Index name prefix is required');
  }
  for (let i = 0; i < 20; i++) {
    const indexName = `${prefix}-${(0, _uuid.v4)().split('-')[0]}`;
    const result = await (0, _exists_index.indexOrAliasExists)(client, indexName);
    if (!result) {
      return indexName;
    }
  }
  throw new Error(_error_codes.ErrorCode.GENERATE_INDEX_NAME_ERROR);
};
exports.generatedIndexName = generatedIndexName;