"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteConnector = exports.DeleteConnectorApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteConnector = async ({
  connectorId,
  connectorName,
  shouldDeleteIndex = false,
  http
}) => {
  await (http === null || http === void 0 ? void 0 : http.delete(`/internal/content_connectors/connectors/${connectorId}`, {
    query: {
      shouldDeleteIndex
    }
  }));
  return {
    connectorName
  };
};
exports.deleteConnector = deleteConnector;
const DeleteConnectorApiLogic = exports.DeleteConnectorApiLogic = (0, _create_api_logic.createApiLogic)(['delete_connector_api_logic'], deleteConnector, {
  showSuccessFlashFn: ({
    connectorName
  }) => _i18n.i18n.translate('xpack.contentConnectors.content.connectors.deleteConnector.successToast.title', {
    defaultMessage: 'The connector {connectorName} was successfully deleted',
    values: {
      connectorName
    }
  })
});