"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedRequest = getFormattedRequest;
var _utils = require("../../lib/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getFormattedRequest(req) {
  let res = req.method + ' ' + req.endpoint;
  if (req.data) {
    const indent = true;
    const formattedData = (0, _utils.formatRequestBodyDoc)([req.data], indent);
    res += '\n' + formattedData.data;
  }
  return res;
}