"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMessagesStorage = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMessagesStorage = () => {
  const storage = (0, _react.useMemo)(() => new _public.Storage(localStorage), []);
  const getMessages = (0, _react.useCallback)(plugin => {
    var _storage$get;
    return (_storage$get = storage.get(`${plugin}-messages`)) !== null && _storage$get !== void 0 ? _storage$get : [];
  }, [storage]);
  const addMessage = (0, _react.useCallback)((plugin, id) => {
    var _storage$get2;
    const pluginStorage = (_storage$get2 = storage.get(`${plugin}-messages`)) !== null && _storage$get2 !== void 0 ? _storage$get2 : [];
    storage.set(`${plugin}-messages`, [...pluginStorage, id]);
  }, [storage]);
  const hasMessage = (0, _react.useCallback)((plugin, id) => {
    var _storage$get3;
    const pluginStorage = (_storage$get3 = storage.get(`${plugin}-messages`)) !== null && _storage$get3 !== void 0 ? _storage$get3 : [];
    return pluginStorage.filter(val => val === id).length > 0;
  }, [storage]);
  const removeMessage = (0, _react.useCallback)((plugin, id) => {
    var _storage$get4;
    const pluginStorage = (_storage$get4 = storage.get(`${plugin}-messages`)) !== null && _storage$get4 !== void 0 ? _storage$get4 : [];
    storage.set(`${plugin}-messages`, [...pluginStorage.filter(val => val !== id)]);
  }, [storage]);
  const clearAllMessages = (0, _react.useCallback)(plugin => storage.remove(`${plugin}-messages`), [storage]);
  return {
    getMessages,
    addMessage,
    clearAllMessages,
    removeMessage,
    hasMessage
  };
};
exports.useMessagesStorage = useMessagesStorage;