"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _title = require("./title");
var _use_cases_context = require("../cases_context/use_cases_context");
var _incremental_id = require("../incremental_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/header_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getHeaderCss = (euiTheme, border) => (0, _react2.css)`
  margin-bottom: ${euiTheme.size.l};
  ${border && (0, _react2.css)`
    border-bottom: ${euiTheme.border.thin};
    padding-bottom: ${euiTheme.size.l};
    .euiProgress {
      top: ${euiTheme.size.l};
    }
  `}
`;
const HeaderPageComponent = ({
  border,
  children,
  isLoading,
  title,
  titleNode,
  incrementalId,
  'data-test-subj': dataTestSubj
}) => {
  const {
    releasePhase
  } = (0, _use_cases_context.useCasesContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("header", {
    css: getHeaderCss(euiTheme, border),
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
            overflow: hidden;
            display: block;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, titleNode || /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: title,
    releasePhase: releasePhase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 25
    }
  }), border && isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 35
    }
  })), children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "header-page-supplements",
    css: (0, _react2.css)`
              display: block;
            `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, typeof incrementalId === 'number' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_incremental_id.IncrementalIdText, {
    incrementalId: incrementalId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }))));
};
HeaderPageComponent.displayName = 'HeaderPage';
const HeaderPage = exports.HeaderPage = /*#__PURE__*/_react.default.memo(HeaderPageComponent);