"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Positionable = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom = require("../../lib/dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/positionable/positionable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Positionable = ({
  children,
  transformMatrix,
  width,
  height
}) => {
  // Throw if there is more than one child
  const childNode = _react.default.Children.only(children);
  const matrix = transformMatrix.map((n, i) => i < 12 ? n : Math.round(n));
  const newStyle = {
    width,
    height,
    marginLeft: -width / 2,
    marginTop: -height / 2,
    position: 'absolute',
    transform: (0, _dom.matrixToCSS)(matrix)
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasPositionable canvasInteractable",
    style: newStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, childNode);
};
exports.Positionable = Positionable;
Positionable.propTypes = {
  children: _propTypes.default.element.isRequired,
  transformMatrix: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
  width: _propTypes.default.number.isRequired,
  height: _propTypes.default.number.isRequired
};