"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleReview = handleReview;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _processors = require("../../util/processors");
var _constants = require("./constants");
var _util = require("./util");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleReview({
  state,
  model
}) {
  const categorizationReviewPrompt = _prompts.CATEGORIZATION_REVIEW_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const categorizationReview = categorizationReviewPrompt.pipe(model).pipe(outputParser);
  const [pipelineResults, selectedIndices] = (0, _util.selectResults)(state.pipelineResults, _constants2.CATEROGIZATION_REVIEW_BATCH_SIZE, new Set(state.stableSamples));
  const currentProcessors = await categorizationReview.invoke({
    current_processors: JSON.stringify(state.currentProcessors, null, 2),
    pipeline_results: JSON.stringify(pipelineResults, null, 2),
    previous_invalid_categorization: state.previousInvalidCategorization,
    previous_error: state.previousError,
    ex_answer: state === null || state === void 0 ? void 0 : state.exAnswer,
    package_name: state === null || state === void 0 ? void 0 : state.packageName,
    compatibility_matrix: JSON.stringify(_constants.ECS_EVENT_TYPES_PER_CATEGORY, null, 2)
  });
  const processors = {
    type: 'categorization',
    processors: currentProcessors
  };
  const currentPipeline = (0, _processors.combineProcessors)(state.initialPipeline, processors);
  return {
    currentPipeline,
    currentProcessors,
    reviewCount: state.reviewCount + 1,
    lastReviewedSamples: selectedIndices,
    lastExecutedChain: 'review'
  };
}