"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAgentConfigurationRouteView = EditAgentConfigurationRouteView;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/agent_configuration/constants");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _agent_configuration_create_edit = require("../../app/settings/agent_configurations/agent_configuration_create_edit");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/settings/edit_agent_configuration_route_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EditAgentConfigurationRouteView() {
  const {
    query: {
      name,
      environment,
      pageStep = _constants.AgentConfigurationPageStep.ChooseSettings
    }
  } = (0, _use_apm_params.useApmParams)('/settings/agent-configuration/edit');
  const res = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /api/apm/settings/agent-configuration/view 2023-10-31', {
      params: {
        query: {
          name,
          environment
        }
      }
    });
  }, [name, environment]);
  return /*#__PURE__*/_react.default.createElement(_agent_configuration_create_edit.AgentConfigurationCreateEdit, {
    pageStep: pageStep,
    existingConfigResult: res,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 10
    }
  });
}