"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDotNetAgentInstructions = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _agent_config_instructions = require("../agent_config_instructions");
var _instruction_variants = require("../instruction_variants");
var _api_key_callout = require("./api_key_callout");
var _agent_status_instructions = require("../agent_status_instructions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/instructions/dotnet_agent.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createDotNetAgentInstructions = commonOptions => {
  const {
    baseUrl,
    apmServerUrl,
    apiKeyDetails,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  } = commonOptions;
  const codeBlock = `var builder = WebApplication.CreateBuilder(args);

builder.Services.AddAllElasticApm();

var app = builder.Build();

// Configure the HTTP request pipeline.

app.Run();`;
  return [{
    title: _i18n.i18n.translate('xpack.apm.onboarding.dotNet.download.title', {
      defaultMessage: 'Download the APM agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.dotNet.download.textPre', {
      defaultMessage: 'Add the the agent package(s) from [NuGet]({allNuGetPackagesLink}) to your .NET application. There are multiple \
      NuGet packages available for different use cases. \n\nFor an ASP.NET Core application with Entity Framework \
      Core download the [Elastic.Apm.NetCoreAll]({netCoreAllApmPackageLink}) package. This package will automatically add every \
      agent component to your application. \n\n In case you would like to minimize the dependencies, you can use the \
      [Elastic.Apm.AspNetCore]({aspNetCorePackageLink}) package for just \
      ASP.NET Core monitoring or the [Elastic.Apm.EfCore]({efCorePackageLink}) package for just Entity Framework Core monitoring. \n\n In \
      case you only want to use the public Agent API for manual instrumentation use the [Elastic.Apm]({elasticApmPackageLink}) package.',
      values: {
        allNuGetPackagesLink: 'https://www.nuget.org/packages?q=Elastic.apm',
        netCoreAllApmPackageLink: 'https://www.nuget.org/packages/Elastic.Apm.NetCoreAll',
        aspNetCorePackageLink: 'https://www.nuget.org/packages/Elastic.Apm.AspNetCore',
        efCorePackageLink: 'https://www.nuget.org/packages/Elastic.Apm.EntityFrameworkCore',
        elasticApmPackageLink: 'https://www.nuget.org/packages/Elastic.Apm'
      }
    })))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.dotNet.configureApplication.title', {
      defaultMessage: 'Add the agent to the application'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.dotNet.configureApplication.textPre', {
      defaultMessage: 'In case of ASP.NET Core with the `Elastic.Apm.NetCoreAll` package, call the `AddAllElasticApm` \
      extension method on the `IServiceCollection` within the `Program.cs` file.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "bash",
      isCopyable: true,
      copyAriaLabel: _i18n.i18n.translate('xpack.apm.onboarding.dotNet.configureApplication.copyAriaLabel', {
        defaultMessage: 'Copy the code to add the APM agent to the dotnet application'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, codeBlock), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.dotNet.configureApplication.textPost', {
      defaultMessage: 'The agent will implicitly read config settings through the application’s \
      `IConfiguration` instance (e.g. from the `appsettings.json` file).'
    })))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.dotNet.configureAgent.title', {
      defaultMessage: 'Sample appsettings.json file:'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
      isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
      isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
      errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: _instruction_variants.INSTRUCTION_VARIANT.DOTNET,
      apmServerUrl: apmServerUrl,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.dotNet.configureAgent.textPost', {
      defaultMessage: 'You can also configure the agent through environment variables. \n \
      See [the documentation]({documentationLink}) for advanced usage, including the [Profiler Auto instrumentation]({profilerLink}) quick start.',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/agent/dotnet/current/configuration.html`,
        profilerLink: `${baseUrl}guide/en/apm/agent/dotnet/current/setup-auto-instrumentation.html#setup-auto-instrumentation`
      }
    })))
  }, (0, _agent_status_instructions.agentStatusCheckInstruction)({
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  })];
};
exports.createDotNetAgentInstructions = createDotNetAgentInstructions;