"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHttpRequestsLayerList = getHttpRequestsLayerList;
var _common = require("@kbn/maps-plugin/common");
var _common2 = require("@kbn/observability-plugin/common");
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _apm = require("../../../../../../../common/es_fields/apm");
var _get_map_layer_style = require("./get_map_layer_style");
var _constants = require("../../../../../../../common/mobile/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COUNTRY_NAME = 'name';
const PER_COUNTRY_LAYER_ID = 'per_country';
const PER_REGION_LAYER_ID = 'per_region';
const HTTP_REQUEST_PER_COUNTRY = `__kbnjoin__count__${PER_COUNTRY_LAYER_ID}`;
const HTTP_REQUESTS_PER_REGION = `__kbnjoin__count__${PER_REGION_LAYER_ID}`;
const label = _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.httpRequests.metric.label', {
  defaultMessage: 'HTTP requests'
});
function getHttpRequestsLayerList(maps, dataViewId, styleColors) {
  const whereQuery = {
    language: 'kuery',
    query: `${_apm.PROCESSOR_EVENT}:${_common2.ProcessorEvent.span} and ${_apm.SPAN_SUBTYPE}:${_constants.MobileSpanSubtype.Http} and ${_apm.SPAN_TYPE}:${_constants.MobileSpanType.External}`
  };
  const httpRequestsByCountryLayer = {
    joins: [{
      leftField: 'iso2',
      right: {
        type: _common.SOURCE_TYPES.ES_TERM_SOURCE,
        id: PER_COUNTRY_LAYER_ID,
        term: _apm.CLIENT_GEO_COUNTRY_ISO_CODE,
        metrics: [{
          type: _common.AGG_TYPE.COUNT,
          label
        }],
        whereQuery,
        indexPatternId: dataViewId,
        applyGlobalQuery: true,
        applyGlobalTime: true,
        applyForceRefresh: true
      }
    }],
    sourceDescriptor: {
      type: _common.SOURCE_TYPES.EMS_FILE,
      id: 'world_countries',
      tooltipProperties: [COUNTRY_NAME]
    },
    style: (0, _get_map_layer_style.getLayerStyle)(HTTP_REQUEST_PER_COUNTRY, _get_map_layer_style.PalleteColors.BluetoRed, styleColors),
    id: (0, _uuid.v4)(),
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.httpRequests.country.label', {
      defaultMessage: 'HTTP requests per country'
    }),
    minZoom: 0,
    maxZoom: 2,
    alpha: 0.75,
    visible: true,
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
  const httpRequestsByRegionLayer = {
    joins: [{
      leftField: 'region_iso_code',
      right: {
        type: _common.SOURCE_TYPES.ES_TERM_SOURCE,
        id: PER_REGION_LAYER_ID,
        term: _apm.CLIENT_GEO_REGION_ISO_CODE,
        metrics: [{
          type: _common.AGG_TYPE.COUNT,
          label
        }],
        whereQuery,
        indexPatternId: dataViewId,
        applyGlobalQuery: true,
        applyGlobalTime: true,
        applyForceRefresh: true
      }
    }],
    sourceDescriptor: {
      type: _common.SOURCE_TYPES.EMS_FILE,
      id: 'administrative_regions_lvl2',
      tooltipProperties: ['region_iso_code']
    },
    style: (0, _get_map_layer_style.getLayerStyle)(HTTP_REQUESTS_PER_REGION, _get_map_layer_style.PalleteColors.YellowtoRed, styleColors),
    id: (0, _uuid.v4)(),
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.httpRequests.region.label', {
      defaultMessage: 'HTTP requests per region'
    }),
    minZoom: 1,
    maxZoom: 24,
    alpha: 0.75,
    visible: true,
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
  return [httpRequestsByRegionLayer, httpRequestsByCountryLayer];
}