"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowStatusSchema = exports.maintenanceWindowPerPageSchema = exports.maintenanceWindowPageSchema = exports.maintenanceWindowCategoryIdsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../constants/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowCategoryIdsSchema = exports.maintenanceWindowCategoryIdsSchema = _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_v.maintenanceWindowCategoryIdTypes.OBSERVABILITY), _configSchema.schema.literal(_v.maintenanceWindowCategoryIdTypes.SECURITY_SOLUTION), _configSchema.schema.literal(_v.maintenanceWindowCategoryIdTypes.MANAGEMENT)]))));
const maintenanceWindowStatusSchema = exports.maintenanceWindowStatusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_v.maintenanceWindowStatus.RUNNING), _configSchema.schema.literal(_v.maintenanceWindowStatus.FINISHED), _configSchema.schema.literal(_v.maintenanceWindowStatus.UPCOMING), _configSchema.schema.literal(_v.maintenanceWindowStatus.ARCHIVED)]);
const maintenanceWindowPageSchema = exports.maintenanceWindowPageSchema = _configSchema.schema.number({
  defaultValue: 1,
  min: 1,
  max: 100,
  meta: {
    description: 'The page number to return.'
  }
});
const maintenanceWindowPerPageSchema = exports.maintenanceWindowPerPageSchema = _configSchema.schema.number({
  defaultValue: 10,
  min: 1,
  max: 100,
  meta: {
    description: 'The number of maintenance windows to return per page.'
  }
});