"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConnectorRequestParamsSchema = exports.createConnectorRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validate_empty_strings = require("../../../../../validate_empty_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createConnectorRequestParamsSchema = exports.createConnectorRequestParamsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An identifier for the connector.'
    }
  }))
}));
const createConnectorRequestBodySchema = exports.createConnectorRequestBodySchema = _configSchema.schema.object({
  name: _configSchema.schema.string({
    validate: _validate_empty_strings.validateEmptyStrings,
    meta: {
      description: 'The display name for the connector.'
    }
  }),
  connector_type_id: _configSchema.schema.string({
    validate: _validate_empty_strings.validateEmptyStrings,
    meta: {
      description: 'The type of connector.'
    }
  }),
  config: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any({
    validate: _validate_empty_strings.validateEmptyStrings
  }), {
    defaultValue: {}
  }),
  secrets: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any({
    validate: _validate_empty_strings.validateEmptyStrings
  }), {
    defaultValue: {}
  })
});