"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.curryBuildPlanServiceNodeFromClassElementMetadata = curryBuildPlanServiceNodeFromClassElementMetadata;
const BindingConstraintsImplementation_1 = require("../../binding/models/BindingConstraintsImplementation");
const ClassElementMetadataKind_1 = require("../../metadata/models/ClassElementMetadataKind");
const buildFilteredServiceBindings_1 = require("../calculations/buildFilteredServiceBindings");
const checkServiceNodeSingleInjectionBindings_1 = require("../calculations/checkServiceNodeSingleInjectionBindings");
const getServiceFromMaybeLazyServiceIdentifier_1 = require("../calculations/getServiceFromMaybeLazyServiceIdentifier");
function curryBuildPlanServiceNodeFromClassElementMetadata(buildServiceNodeBindings) {
    return (params, bindingConstraintsList, elementMetadata) => {
        const serviceIdentifier = (0, getServiceFromMaybeLazyServiceIdentifier_1.getServiceFromMaybeLazyServiceIdentifier)(elementMetadata.value);
        const updatedBindingConstraintsList = bindingConstraintsList.concat({
            getAncestorsCalled: false,
            name: elementMetadata.name,
            serviceIdentifier,
            tags: elementMetadata.tags,
        });
        const bindingConstraints = new BindingConstraintsImplementation_1.BindingConstraintsImplementation(updatedBindingConstraintsList.last);
        const chained = elementMetadata.kind === ClassElementMetadataKind_1.ClassElementMetadataKind.multipleInjection &&
            elementMetadata.chained;
        const filteredServiceBindings = (0, buildFilteredServiceBindings_1.buildFilteredServiceBindings)(params, bindingConstraints, {
            chained,
        });
        const serviceNodeBindings = [];
        const serviceNode = {
            bindings: serviceNodeBindings,
            isContextFree: true,
            serviceIdentifier,
        };
        serviceNodeBindings.push(...buildServiceNodeBindings(params, updatedBindingConstraintsList, filteredServiceBindings, serviceNode, chained));
        serviceNode.isContextFree =
            !updatedBindingConstraintsList.last.elem.getAncestorsCalled;
        if (elementMetadata.kind === ClassElementMetadataKind_1.ClassElementMetadataKind.singleInjection) {
            (0, checkServiceNodeSingleInjectionBindings_1.checkServiceNodeSingleInjectionBindings)(serviceNode, elementMetadata.optional, updatedBindingConstraintsList.last);
            const [planBindingNode] = serviceNodeBindings;
            serviceNode.bindings = planBindingNode;
        }
        return serviceNode;
    };
}
//# sourceMappingURL=curryBuildPlanServiceNodeFromClassElementMetadata.js.map