"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwAtInvalidClassMetadata = throwAtInvalidClassMetadata;
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const MaybeClassElementMetadataKind_1 = require("../models/MaybeClassElementMetadataKind");
function throwAtInvalidClassMetadata(type, classMetadata) {
    const errors = [];
    for (let i = 0; i < classMetadata.constructorArguments.length; ++i) {
        const constructorArgument = classMetadata.constructorArguments[i];
        if (constructorArgument === undefined ||
            constructorArgument.kind === MaybeClassElementMetadataKind_1.MaybeClassElementMetadataKind.unknown) {
            errors.push(`  - Missing or incomplete metadata for type "${type.name}" at constructor argument with index ${i.toString()}.
Every constructor parameter must be decorated either with @inject, @multiInject or @unmanaged decorator.`);
        }
    }
    for (const [propertyKey, property] of classMetadata.properties) {
        if (property.kind === MaybeClassElementMetadataKind_1.MaybeClassElementMetadataKind.unknown) {
            errors.push(`  - Missing or incomplete metadata for type "${type.name}" at property "${propertyKey.toString()}".
This property must be decorated either with @inject or @multiInject decorator.`);
        }
    }
    if (errors.length === 0) {
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.unknown, `Unexpected class metadata for type "${type.name}" with uncompletion traces.
This might be caused by one of the following reasons:

1. A third party library is targeting inversify reflection metadata.
2. A bug is causing the issue. Consider submiting an issue to fix it.`);
    }
    throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.missingInjectionDecorator, `Invalid class metadata at type ${type.name}:

${errors.join('\n\n')}`);
}
//# sourceMappingURL=throwAtInvalidClassMetadata.js.map